/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.PositiveIntFormatter;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.SizeChangeDialog;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.ValidDocumentat;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

public class SizeChangeDialog
extends JFrame {
    private BoardView mOwnerFrame;
    private JTextField mWidthField;
    private JTextField mHeightField;

    public static void showDialog(final BoardView inOwner, final int inInitWidth, final int inInitHeight) {
        if (EventQueue.isDispatchThread()) {
            SizeChangeDialog aDialog = new SizeChangeDialog();
            aDialog.initialize(inOwner, inInitWidth, inInitHeight);
            aDialog.show();
        } else {
            Runnable aAction = new Runnable(){

                public void run() {
                    SizeChangeDialog.showDialog(inOwner, inInitWidth, inInitHeight);
                }
            };
            EventQueue.invokeLater(aAction);
        }
    }

    public void initialize(BoardView inOwner, int inInitWidth, int inInitHeight) {
        this.mOwnerFrame = inOwner;
        this.mWidthField.setText(String.valueOf(inInitWidth));
        this.mHeightField.setText(String.valueOf(inInitHeight));
    }

    protected void frameInit() {
        super.frameInit();
        Container aPane = this.getContentPane();
        JPanel aPanel = new JPanel(new GridLayout(2, 2));
        aPane.add((Component)aPanel, "Center");
        aPanel.add(new JLabel("width : ", 4));
        this.mWidthField = new JTextField();
        this.mWidthField.setDocument(new ValidDocumentat(new PositiveIntFormatter(2)));
        class FocusHandler
        implements FocusListener {
            private final /* synthetic */ SizeChangeDialog this$0;

            FocusHandler(SizeChangeDialog this$0) {
                this.this$0 = this$0;
            }

            public void focusGained(FocusEvent inEvent) {
                JTextField aField = (JTextField)inEvent.getSource();
                aField.selectAll();
            }

            public void focusLost(FocusEvent inEvent) {
            }
        }
        this.mWidthField.addFocusListener(new FocusHandler(this));
        class ApproveHandler
        implements KeyListener {
            private final /* synthetic */ SizeChangeDialog this$0;

            ApproveHandler(SizeChangeDialog this$0) {
                this.this$0 = this$0;
            }

            public void keyPressed(KeyEvent inEvent) {
                int aPressedKey = inEvent.getKeyCode();
                switch (aPressedKey) {
                    case 27: {
                        SizeChangeDialog.access$000(this.this$0);
                        break;
                    }
                    case 10: {
                        SizeChangeDialog.access$100(this.this$0);
                    }
                }
            }

            public void keyReleased(KeyEvent inEvent) {
            }

            public void keyTyped(KeyEvent inEvent) {
            }
        }
        this.mWidthField.addKeyListener(new ApproveHandler(this));
        aPanel.add(this.mWidthField);
        aPanel.add(new JLabel("height : ", 4));
        this.mHeightField = new JTextField();
        this.mHeightField.setDocument(new ValidDocumentat(new PositiveIntFormatter(2)));
        this.mHeightField.addFocusListener(new FocusHandler(this));
        this.mHeightField.addKeyListener(new ApproveHandler(this));
        aPanel.add(this.mHeightField);
        aPanel = new JPanel();
        aPane.add((Component)aPanel, "South");
        JButton aButton = new JButton("OK");
        aPanel.add(aButton);
        aButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent inEvent) {
                SizeChangeDialog.this.approveAction();
            }
        });
        aButton.addKeyListener(new ApproveHandler(this));
        aButton = new JButton("Cancel");
        aPanel.add(aButton);
        aButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent inEvent) {
                SizeChangeDialog.this.cancelAction();
            }
        });
        aButton.addKeyListener(new ApproveHandler(this));
        this.pack();
    }

    private void approveAction() {
        try {
            int aWidth = Integer.parseInt(this.mWidthField.getText());
            int aHeight = Integer.parseInt(this.mHeightField.getText());
            this.mOwnerFrame.createBoard(aWidth, aHeight);
            this.mOwnerFrame.repaint();
            this.dispose();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void cancelAction() {
        this.dispose();
    }

    private SizeChangeDialog() {
    }
}

