/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeStateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeEvent;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

public class SolutionCheckModel
extends AbstractDecoratedModel {
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private int[] mCheckArray;
    private boolean mArrayCreated = false;

    public SolutionCheckModel(Model inModel) {
        super(inModel);
    }

    public boolean check() {
        StateManager aManager = StateManager.getInstance();
        if (!this.mArrayCreated) {
            this.mCheckArray = this.initCheckArray();
        }
        return new CheckWorker().start(this.mCheckArray);
    }

    private int[] initCheckArray() {
        StateManager aManager = StateManager.getInstance();
        int[] aArray = new int[this.getWidth() * this.getHeight()];
        int y = 0;
        int i = 0;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                if (this.isNumberAt(x, y)) {
                    try {
                        int aNum;
                        aArray[i] = aNum = Integer.parseInt(aManager.findIdentityOf(this.getCurStateAt(x, y)));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalStateException("The simbol of Number State cannot be parsed as integer.");
                    }
                }
                ++x;
                ++i;
            }
            ++y;
        }
        this.mArrayCreated = true;
        return aArray;
    }

    public void createBoardSelf(int inWidth, int inHeight) {
        this.mArrayCreated = false;
        this.mCheckArray = null;
    }

    protected Point[] lastModifiedSelf() {
        return NO_MODIFIED;
    }

    protected boolean isModifiedSelf() {
        return false;
    }

    public boolean isAcceptableEvent(StateEventCode inCode) {
        return true;
    }

    public void selectionChanged(ModelChangeEvent inEvent) {
    }

    public void selectionDetermined(ModelChangeEvent ioEvent) {
    }

    protected void flushSelf() {
    }

    private class CheckWorker {
        private List mQueue;
        private boolean[] mDoubleCkecked;
        private int[] mCheckArray;

        private CheckWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean start(int[] inCheckArray) {
            if (null == inCheckArray) throw new IllegalArgumentException("check array isnot correctly initialized.");
            if (inCheckArray.length == 0) {
                throw new IllegalArgumentException("check array isnot correctly initialized.");
            }
            this.initialize(inCheckArray);
            try {
                while (!this.mQueue.isEmpty()) {
                    int aIndex = (Integer)this.mQueue.remove(0);
                    if (0 < this.mCheckArray[aIndex]) {
                        this.checkSolution(aIndex);
                    }
                    if (0 <= this.mCheckArray[aIndex]) continue;
                    boolean bl = false;
                    Object var5_5 = null;
                    this.mCheckArray = null;
                    this.mDoubleCkecked = null;
                    this.mQueue = null;
                    return bl;
                }
                int i = 0;
                while (i < this.mCheckArray.length) {
                    if (0 != this.mCheckArray[i]) {
                        boolean bl = false;
                        Object var5_6 = null;
                        this.mCheckArray = null;
                        this.mDoubleCkecked = null;
                        this.mQueue = null;
                        return bl;
                    }
                    ++i;
                }
                Object var5_7 = null;
                this.mCheckArray = null;
                this.mDoubleCkecked = null;
                this.mQueue = null;
                return true;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.mCheckArray = null;
                this.mDoubleCkecked = null;
                this.mQueue = null;
                throw throwable;
            }
        }

        private void checkSolution(int inIndex) {
            int aX = inIndex % SolutionCheckModel.this.getWidth();
            int aY = inIndex / SolutionCheckModel.this.getWidth();
            Point aPos = new Point(aX, aY);
            int i = 0;
            while (i < DIRECTIONS.length) {
                StateEventCode aCode;
                Point aDiff = DIRECTIONS[i].getDifference();
                aPos.translate(aDiff.x, aDiff.y);
                if (SolutionCheckModel.this.contains(aPos.x, aPos.y) && !SolutionCheckModel.this.isSpaceAt(aPos.x, aPos.y) && SolutionCheckModel.this.isTransitAt(aPos.x, aPos.y, aCode = HashikakeStateEventCode.createParallelCode(DIRECTIONS[i]))) {
                    int aCount = HashikakeStateManagerImpl.countBridge(SolutionCheckModel.this.getCurStateAt(aPos.x, aPos.y));
                    if (0 == aCount) {
                        throw new IllegalStateException("Both islands donot neighbor each other.\n\tOne side : " + new Point(aX, aY) + "\n" + "\tOpposite side : " + aPos);
                    }
                    int aOpposite = this.findIndexOfOppositeSide(aPos, aDiff);
                    if (!this.mDoubleCkecked[aOpposite]) {
                        int n = aOpposite;
                        this.mCheckArray[n] = this.mCheckArray[n] - aCount;
                        int n2 = inIndex;
                        this.mCheckArray[n2] = this.mCheckArray[n2] - aCount;
                        this.mDoubleCkecked[inIndex] = true;
                        this.mQueue.add(new Integer(aOpposite));
                    }
                }
                aPos.translate(-aDiff.x, -aDiff.y);
                ++i;
            }
        }

        private int findIndexOfOppositeSide(Point inPos, Point inDiff) {
            Point aPos = new Point(inPos);
            aPos.translate(inDiff.x, inDiff.y);
            do {
                if (SolutionCheckModel.this.isNumberAt(aPos.x, aPos.y)) {
                    return this.toIndex(aPos.x, aPos.y);
                }
                aPos.translate(inDiff.x, inDiff.y);
            } while (SolutionCheckModel.this.contains(aPos.x, aPos.y));
            throw new IllegalStateException("The opposite side is no existance.");
        }

        private int toIndex(int inX, int inY) {
            return inY * SolutionCheckModel.this.getWidth() + inX;
        }

        private void initialize(int[] inCheckArray) {
            this.mDoubleCkecked = new boolean[inCheckArray.length];
            this.mCheckArray = new int[inCheckArray.length];
            System.arraycopy(inCheckArray, 0, this.mCheckArray, 0, inCheckArray.length);
            this.mQueue = new LinkedList();
            int i = 0;
            while (i < this.mCheckArray.length) {
                if (0 < this.mCheckArray[i]) {
                    this.mQueue.add(new Integer(i));
                    break;
                }
                ++i;
            }
        }
    }
}

