/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigNSBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigWEBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BranchState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NSBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.WEBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;

public class HashikakeStateManagerImpl
implements StateManagerImpl {
    public static final String SPACE_ID = "s";
    public static final String NS_BRIDGE_ID = "i";
    public static final String BIG_NS_BRIDGE_ID = "ii";
    public static final String WE_BRIDGE_ID = "-";
    public static final String BIG_WE_BRIDGE_ID = "=";
    public static final String NULL_ID = "";
    private Map mStateMap = new HashMap();
    private Map mStateToIDMap = new HashMap();
    private Map mTransitMap = new HashMap();
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState;

    public HashikakeStateManagerImpl() {
        SpaceState aSpace = new SpaceState();
        NSBridgeState aNSBridge = new NSBridgeState();
        BigNSBridgeState aBigNSBridge = new BigNSBridgeState();
        WEBridgeState aWEBridge = new WEBridgeState();
        BigWEBridgeState aBigWEBridge = new BigWEBridgeState();
        StateEventCode aHoriz = HashikakeStateEventCode.createHorizontalCode();
        StateEventCode aVert = HashikakeStateEventCode.createVerticalCode();
        this.installStateMap(SPACE_ID, aSpace);
        this.installStateMap(NS_BRIDGE_ID, aNSBridge);
        this.installStateMap(BIG_NS_BRIDGE_ID, aBigNSBridge);
        this.installStateMap(WE_BRIDGE_ID, aWEBridge);
        this.installStateMap(BIG_WE_BRIDGE_ID, aBigWEBridge);
        this.installTransitMap((State)aNSBridge, (State)aSpace, aBigNSBridge, new StateEventCode[]{aVert});
        this.installTransitMap((State)aBigNSBridge, (State)aNSBridge, aSpace, new StateEventCode[]{aVert});
        this.installTransitMap((State)aWEBridge, (State)aSpace, aBigWEBridge, new StateEventCode[]{aHoriz});
        this.installTransitMap((State)aBigWEBridge, (State)aWEBridge, aSpace, new StateEventCode[]{aHoriz});
        this.installTransitMap((State)aSpace, (State)aSpace, new BranchState.TransitHint[]{new BranchState.TransitHint(aNSBridge, aVert), new BranchState.TransitHint(aWEBridge, aHoriz)}, new StateEventCode[]{aVert, aHoriz});
    }

    private void installTransitMap(State inCur, State inPrev, State inNext, StateEventCode[] inEvent) {
        this.mTransitMap.put(inCur, new TransitRecord(inPrev, inNext, inEvent));
    }

    private void installTransitMap(State inCur, State inPrev, BranchState.TransitHint[] inNext, StateEventCode[] inEvent) {
        this.installTransitMap(inCur, inPrev, new BranchState(inNext), inEvent);
    }

    private void installStateMap(String inID, State inState) {
        this.mStateMap.put(inID, inState);
        this.mStateToIDMap.put(inState, inID);
    }

    public State createStateOf(String inStateID) {
        String aID = inStateID.trim().toLowerCase();
        if (this.mStateMap.containsKey(aID)) {
            return (State)this.mStateMap.get(aID);
        }
        try {
            int aNum = Integer.parseInt(aID);
            NumberState aState = new NumberState(aNum);
            this.installStateMap(aID, aState);
            return aState;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal State ID : " + inStateID);
        }
    }

    public State createDefaultState() {
        return this.createStateOf(SPACE_ID);
    }

    public String findIdentityOf(State inState) {
        if (!this.mStateToIDMap.containsKey(inState)) {
            throw new IllegalArgumentException("The ID corresponding to the state is no existance.");
        }
        return (String)this.mStateToIDMap.get(inState);
    }

    public State getNextState(State inState) {
        throw new UnsupportedOperationException("The method getNextState(State) is not supported");
    }

    public State getNextState(State inState, StateEventCode inEvent) {
        if (!this.mTransitMap.containsKey(inState)) {
            throw new IllegalArgumentException("The next State is no existence.");
        }
        TransitRecord aRec = (TransitRecord)this.mTransitMap.get(inState);
        return aRec.mNext.onEnter(inEvent);
    }

    public State getPrevState(State inState) {
        throw new UnsupportedOperationException("The method getPrevState(State) is not supported");
    }

    public State getPrevState(State inState, StateEventCode inEvent) {
        if (!this.mTransitMap.containsKey(inState)) {
            throw new IllegalArgumentException("The next State is no existence.");
        }
        TransitRecord aRec = (TransitRecord)this.mTransitMap.get(inState);
        return aRec.mPrev.onEnter(inEvent);
    }

    public boolean isNumberState(State inState) {
        return inState instanceof NumberState;
    }

    public boolean isSpaceState(State inState) {
        return inState instanceof SpaceState;
    }

    public boolean isTransit(State inState, StateEventCode inEvent) {
        if (!this.mTransitMap.containsKey(inState)) {
            return false;
        }
        TransitRecord aRec = (TransitRecord)this.mTransitMap.get(inState);
        int i = 0;
        while (i < aRec.mEvent.length) {
            if (aRec.mEvent[i] == inEvent) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isTransit(State inState) {
        throw new UnsupportedOperationException("The method isTransit(State) is not supported");
    }

    public static int countBridge(State inState) {
        if ((class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NSBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState).equals(inState.getClass()) || (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.WEBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState).equals(inState.getClass())) {
            return 1;
        }
        if ((class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigNSBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState).equals(inState.getClass()) || (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigWEBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState).equals(inState.getClass())) {
            return 2;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SPACE_ID = SPACE_ID;
        NS_BRIDGE_ID = NS_BRIDGE_ID;
        BIG_NS_BRIDGE_ID = BIG_NS_BRIDGE_ID;
        WE_BRIDGE_ID = WE_BRIDGE_ID;
        BIG_WE_BRIDGE_ID = BIG_WE_BRIDGE_ID;
        NULL_ID = NULL_ID;
    }

    private static class TransitRecord {
        final State mPrev;
        final State mNext;
        final StateEventCode[] mEvent;

        TransitRecord(State inPrev, State inNext, StateEventCode[] inEvent) {
            this.mPrev = inPrev;
            this.mNext = inNext;
            this.mEvent = inEvent;
        }
    }
}

