/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Point;
import java.util.Arrays;
import java.util.HashSet;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeEvent;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberActiveState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SelectionState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class BridgibleCheckModel
extends AbstractDecoratedModel {
    private static final Point EMPTY_POS = ModelConstants.ILLEGAL_POS;
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private Point mPressedPos = EMPTY_POS;
    private Point mReleasedPos = EMPTY_POS;
    private Point[] mSelectedPos = NO_MODIFIED;
    private Point[] mDeactivatedPos = NO_MODIFIED;
    private boolean mIsModified = false;
    private Direction mDirection = Direction.NO;

    public BridgibleCheckModel(Model inModel) {
        super(inModel);
    }

    public State getCurStateAt(int inX, int inY) {
        Point aPos = new Point(inX, inY);
        State aState = super.getCurStateAt(inX, inY);
        if (aPos.equals(this.mPressedPos)) {
            return new NumberActiveState(aState);
        }
        Point[] aModifiedPos = this.mSelectedPos;
        int i = 0;
        while (i < aModifiedPos.length) {
            if (aPos.equals(aModifiedPos[i])) {
                return new SelectionState(aState);
            }
            ++i;
        }
        return aState;
    }

    public void createBoardSelf(int inWidth, int inHeight) {
    }

    protected Point[] lastModifiedSelf() {
        HashSet<Point> aSet = new HashSet<Point>();
        if (this.mPressedPos != EMPTY_POS) {
            aSet.add(this.mPressedPos);
        }
        if (this.mReleasedPos != EMPTY_POS) {
            aSet.add(this.mReleasedPos);
        }
        aSet.addAll(Arrays.asList(this.mDeactivatedPos));
        aSet.addAll(Arrays.asList(this.mSelectedPos));
        return aSet.toArray(new Point[0]);
    }

    protected boolean isModifiedSelf() {
        return this.mIsModified;
    }

    public boolean isAcceptableEvent(StateEventCode inCode) {
        return true;
    }

    public void selectionChanged(ModelChangeEvent inEvent) {
        Direction aDirection = inEvent.getDirection();
        if (aDirection == Direction.NO) {
            this.mPressedPos = inEvent.getPos();
            this.mDeactivatedPos = this.mSelectedPos;
            this.mSelectedPos = NO_MODIFIED;
            this.mDirection = aDirection;
            this.mIsModified = true;
            return;
        }
        if (aDirection == this.mDirection) {
            return;
        }
        this.mDirection = aDirection;
        this.activate(aDirection);
    }

    private void activate(Direction inDirection) {
        this.mDeactivatedPos = this.mSelectedPos;
        if (!this.isBuildBridge(inDirection)) {
            this.mSelectedPos = NO_MODIFIED;
            return;
        }
        Point aDiff = inDirection.getDifference();
        Point aPos = new Point(this.mPressedPos);
        HashSet<Point> aSet = new HashSet<Point>();
        aPos.translate(aDiff.x, aDiff.y);
        do {
            aSet.add(new Point(aPos));
            aPos.translate(aDiff.x, aDiff.y);
        } while (!this.isNumberAt(aPos.x, aPos.y));
        this.mSelectedPos = aSet.toArray(new Point[0]);
        this.mIsModified = true;
    }

    private boolean isBuildBridge(Direction inDirection) {
        Point aDiff = inDirection.getDifference();
        Point aPos = new Point(this.mPressedPos);
        StateEventCode aCode = UtilityFuncs.resolveTransitCode(inDirection);
        aPos.translate(aDiff.x, aDiff.y);
        if (!this.isTransitAt(aPos.x, aPos.y, aCode)) {
            return false;
        }
        do {
            aPos.translate(aDiff.x, aDiff.y);
            if (!this.isNumberAt(aPos.x, aPos.y)) continue;
            return true;
        } while (this.contains(aPos.x, aPos.y) && this.isTransitAt(aPos.x, aPos.y, aCode));
        return false;
    }

    public void selectionDetermined(ModelChangeEvent ioEvent) {
        if (this.mPressedPos.equals(EMPTY_POS)) {
            return;
        }
        ioEvent.setModifiedPos(this.mSelectedPos);
        this.mReleasedPos = this.mPressedPos;
        this.mPressedPos = EMPTY_POS;
        this.mSelectedPos = NO_MODIFIED;
        this.mDirection = Direction.NO;
        this.mIsModified = true;
    }

    protected void flushSelf() {
        this.mReleasedPos = EMPTY_POS;
        this.mIsModified = false;
    }
}

