/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashSet;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeEvent;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class BoardModel
extends AbstractDecoratedModel {
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private Cell[] mCells;
    private int mWidth;
    private int mHeight;
    private Point[] mModifiedPos = NO_MODIFIED;

    public BoardModel() {
        this(NullModel.getInstance());
    }

    public BoardModel(Model inModel) {
        super(inModel);
    }

    public void createBoardSelf(int inWidth, int inHeight) {
        this.mWidth = inWidth;
        this.mHeight = inHeight;
        this.mCells = new Cell[inWidth * inHeight];
    }

    public void setProblem(ProblemInfo inInfo) {
        if (this.mWidth != inInfo.getWidth() || this.mHeight != inInfo.getHeight()) {
            this.createBoard(inInfo.getWidth(), inInfo.getHeight());
        }
        HashSet<Point> aSet = new HashSet<Point>();
        int y = 0;
        int i = 0;
        while (y < this.mHeight) {
            int x = 0;
            while (x < this.mWidth) {
                this.mCells[y * this.mWidth + x] = new Cell((String)inInfo.getRecordAt(i++));
                aSet.add(new Point(x, y));
                ++x;
            }
            ++y;
        }
        this.mModifiedPos = aSet.toArray(new Point[aSet.size()]);
    }

    public boolean check() {
        return false;
    }

    public void reset() {
        HashSet<Point> aSet = new HashSet<Point>();
        int y = 0;
        boolean i = false;
        while (y < this.getHeight()) {
            int x = 0;
            while (x < this.getWidth()) {
                Cell aCell = this.getCellAt(x, y);
                if (!aCell.isSpace() && !aCell.isNumber()) {
                    aSet.add(new Point(x, y));
                    aCell.reset();
                }
                ++x;
            }
            ++y;
        }
        this.mModifiedPos = aSet.toArray(new Point[aSet.size()]);
    }

    public Dimension getSize() {
        return new Dimension(this.mWidth, this.mHeight);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public State getCurStateAt(int inX, int inY) {
        Cell aCell = this.getCellAt(inX, inY);
        return this.getCellAt(inX, inY).getCurState();
    }

    public void nextStateAt(int inX, int inY) {
        throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method nextStateAt.");
    }

    public void nextStateAt(int inX, int inY, StateEventCode inEvent) {
        if (this.isNumberAt(inX, inY)) {
            return;
        }
        State aState = this.getCurStateAt(inX, inY);
        aState = StateManager.getInstance().getNextState(aState, inEvent);
        this.setCurStateAt(inX, inY, aState);
    }

    public void prevStateAt(int inX, int inY) {
        throw new UnsupportedOperationException("Needs to pass a arg inEvent for the method prevStateAt.");
    }

    public void prevStateAt(int inX, int inY, StateEventCode inEvent) {
        if (this.isNumberAt(inX, inY)) {
            return;
        }
        State aState = this.getCurStateAt(inX, inY);
        aState = StateManager.getInstance().getPrevState(aState, inEvent);
        this.setCurStateAt(inX, inY, aState);
    }

    private void setCurStateAt(int inX, int inY, State inState) {
        Cell aCell = this.getCellAt(inX, inY);
        aCell.setCurState(inState);
    }

    protected Point[] lastModifiedSelf() {
        return this.mModifiedPos;
    }

    protected boolean isModifiedSelf() {
        return this.mModifiedPos.length != 0;
    }

    protected void flushSelf() {
        this.mModifiedPos = NO_MODIFIED;
    }

    public boolean isNumberAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isNumber();
    }

    public boolean isSpaceAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isSpace();
    }

    public boolean isTransitAt(int inX, int inY, StateEventCode inTransitCode) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isTransit(inTransitCode);
    }

    public boolean isTransitAt(int inX, int inY) {
        throw new UnsupportedOperationException("the method isTransitAt(int, int) is unsupported");
    }

    public boolean isAcceptableEvent(StateEventCode inCode) {
        return inCode == HashikakeStateEventCode.createVerticalCode() || inCode == HashikakeStateEventCode.createNoTransitCode();
    }

    public void selectionChanged(ModelChangeEvent inEvent) {
        if (NO_MODIFIED != this.mModifiedPos) {
            this.mModifiedPos = NO_MODIFIED;
        }
    }

    public void selectionDetermined(ModelChangeEvent inEvent) {
        StateEventCode aTransitCode = UtilityFuncs.resolveTransitCode(inEvent.getDirection());
        Point[] aPos = inEvent.lastModified();
        int i = 0;
        while (i < aPos.length) {
            if (this.isTransitAt(aPos[i].x, aPos[i].y, aTransitCode)) {
                if (inEvent.isTransitNext()) {
                    this.nextStateAt(aPos[i].x, aPos[i].y, aTransitCode);
                } else {
                    this.prevStateAt(aPos[i].x, aPos[i].y, aTransitCode);
                }
            }
            ++i;
        }
        this.mModifiedPos = aPos;
    }

    public boolean contains(int inX, int inY) {
        return inX >= 0 && inX < this.mWidth && inY >= 0 && inY < this.mHeight;
    }

    public State getCorrectStateAt(int inX, int inY) {
        throw new UnsupportedOperationException("This model isnot supported getCorrectStateAt method.");
    }

    private Cell getCellAt(int inX, int inY) {
        if (inX < 0 || inY < 0 || inX >= this.mWidth || inY >= this.mHeight) {
            throw new IndexOutOfBoundsException("0 < x <= " + this.mWidth + ", 0 < y <= " + this.mHeight + " (inX : " + inX + ", inY : " + inY + ")");
        }
        return this.mCells[this.mWidth * inY + inX];
    }

    private static class Cell {
        private State mState;

        Cell(String inID) {
            StateManager amanager = StateManager.getInstance();
            try {
                Integer.parseInt(inID.trim());
                this.mState = amanager.createStateOf(inID);
            }
            catch (NumberFormatException e) {
                this.mState = amanager.createDefaultState();
            }
        }

        void reset() {
            if (!this.isNumber()) {
                this.mState = StateManager.getInstance().createDefaultState();
            }
        }

        boolean isNumber() {
            return StateManager.getInstance().isNumberState(this.mState);
        }

        boolean isSpace() {
            return StateManager.getInstance().isSpaceState(this.mState);
        }

        boolean isTransit(StateEventCode inEventCode) {
            return StateManager.getInstance().isTransit(this.mState, inEventCode);
        }

        State getCurState() {
            return this.mState;
        }

        void setCurState(State inState) {
            this.mState = inState;
        }
    }
}

