/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;

public class MarshallingContext
implements IMarshallingContext {
    private Writer m_writer;
    private boolean m_indent;
    private boolean m_textSeen;
    private int m_indentSpaces;
    private int m_nestingDepth;
    private char[] m_spaces;
    protected String[] m_classes;
    protected int m_globalCount;
    protected IMarshaller[] m_marshallers;
    protected Stack m_namespaceStack;
    protected int m_namespaceDepth;
    protected String[] m_uris;
    protected String[] m_prefixes;

    public MarshallingContext(String[] stringArray, IMarshaller[] iMarshallerArray, String[] stringArray2) {
        this.m_classes = stringArray;
        this.m_globalCount = iMarshallerArray.length;
        this.m_marshallers = new IMarshaller[stringArray.length];
        System.arraycopy(iMarshallerArray, 0, this.m_marshallers, 0, iMarshallerArray.length);
        this.m_uris = stringArray2;
        this.m_prefixes = new String[stringArray2.length];
        this.m_prefixes[0] = "";
        this.m_prefixes[1] = "xml:";
        this.m_namespaceStack = new Stack();
        this.m_namespaceDepth = -1;
    }

    public void setOutput(OutputStream outputStream, String string) throws JiBXException {
        try {
            this.m_writer = string == null ? new BufferedWriter(new OutputStreamWriter(outputStream)) : new BufferedWriter(new OutputStreamWriter(outputStream, string));
            this.reset();
        }
        catch (IOException iOException) {
            throw new JiBXException("Error setting output", iOException);
        }
    }

    public void setOutput(Writer writer) {
        this.m_writer = writer;
        this.reset();
    }

    public void setIndent(int n) {
        if (n >= 0) {
            this.m_indent = true;
            this.m_indentSpaces = n;
            this.m_spaces = "\n                              ".toCharArray();
        } else {
            this.m_indent = false;
        }
    }

    public void reset() {
        this.m_textSeen = false;
        this.m_nestingDepth = 0;
        int n = this.m_globalCount;
        while (n < this.m_marshallers.length) {
            this.m_marshallers[n] = null;
            ++n;
        }
    }

    private void indent() throws IOException {
        if (this.m_indent) {
            int n = 1 + this.m_nestingDepth * this.m_indentSpaces;
            if (n > this.m_spaces.length) {
                int n2 = Math.max(n, this.m_spaces.length * 2 + 1);
                this.m_spaces = new char[n2];
                this.m_spaces[0] = 10;
                int n3 = 1;
                while (n3 < n2) {
                    this.m_spaces[n3] = 32;
                    ++n3;
                }
            }
            this.m_writer.write(this.m_spaces, 0, n);
        }
    }

    private void writeAttribute(String string) throws IOException {
        if (string.indexOf(34) < 0 && string.indexOf(38) < 0 && string.indexOf(60) < 0) {
            this.m_writer.write(string);
        } else {
            int n = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (c == '\"') {
                    this.m_writer.write(string, n, n2 - n);
                    n = n2 + 1;
                    this.m_writer.write("&quot;");
                } else if (c == '&') {
                    this.m_writer.write(string, n, n2 - n);
                    n = n2 + 1;
                    this.m_writer.write("&amp;");
                } else if (c == '<') {
                    this.m_writer.write(string, n, n2 - n);
                    n = n2 + 1;
                    this.m_writer.write("&lt;");
                }
                ++n2;
            }
            this.m_writer.write(string, n, string.length() - n);
        }
    }

    private void writeContent(String string) throws IOException {
        if (string.indexOf(38) < 0 && string.indexOf(60) < 0) {
            this.m_writer.write(string);
        } else {
            int n = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                char c = string.charAt(n2);
                if (c == '&') {
                    this.m_writer.write(string, n, n2 - n);
                    n = n2 + 1;
                    this.m_writer.write("&amp;");
                } else if (c == '<') {
                    this.m_writer.write(string, n, n2 - n);
                    n = n2 + 1;
                    this.m_writer.write("&lt;");
                }
                ++n2;
            }
            this.m_writer.write(string, n, string.length() - n);
        }
    }

    public void startDocument(String string, Boolean bl) throws JiBXException {
        try {
            this.m_writer.write("<?xml version=\"1.0\"");
            if (string != null) {
                this.m_writer.write(" encoding=\"" + string + '\"');
            }
            if (bl != null) {
                this.m_writer.write(" standalone=\"" + (bl != false ? "yes" : "no") + '\"');
            }
            this.m_writer.write("?>");
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public void startDocument(String string, Boolean bl, OutputStream outputStream) throws JiBXException {
        this.setOutput(outputStream, string);
        this.startDocument(string, bl);
    }

    public void startDocument(String string, Boolean bl, Writer writer) throws JiBXException {
        this.setOutput(writer);
        this.startDocument(string, bl);
    }

    public void endDocument() throws JiBXException {
        try {
            this.m_writer.flush();
            this.m_writer.close();
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    private String prefixText(int n) throws JiBXException {
        try {
            return this.m_prefixes[n].toString();
        }
        catch (NullPointerException nullPointerException) {
            throw new JiBXException("Namespace URI has not been declared.");
        }
    }

    public MarshallingContext startTag(int n, String string) throws JiBXException {
        try {
            this.indent();
            this.m_writer.write("<" + this.prefixText(n) + string + '>');
            ++this.m_nestingDepth;
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext startTagAttributes(int n, String string) throws JiBXException {
        try {
            this.indent();
            this.m_writer.write("<" + this.prefixText(n) + string);
            ++this.m_nestingDepth;
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext attribute(int n, String string, String string2) throws JiBXException {
        try {
            this.m_writer.write(" " + this.prefixText(n) + string + "=\"");
            this.writeAttribute(string2);
            this.m_writer.write(34);
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext attribute(int n, String string, int n2) throws JiBXException {
        try {
            this.m_writer.write(" " + this.prefixText(n) + string + "=\"" + n2 + '\"');
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext closeStartContent() throws JiBXException {
        try {
            this.m_writer.write(62);
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext closeStartEmpty() throws JiBXException {
        try {
            this.m_writer.write("/>");
            if (--this.m_nestingDepth == this.m_namespaceDepth) {
                this.closeNamespaces();
            }
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext textContent(String string) throws JiBXException {
        try {
            this.writeContent(string);
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext textContent(int n) throws JiBXException {
        try {
            this.m_writer.write(Integer.toString(n));
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext endTag(int n, String string) throws JiBXException {
        try {
            --this.m_nestingDepth;
            if (!this.m_textSeen) {
                this.indent();
            }
            this.m_writer.write("</" + this.prefixText(n) + string + '>');
            if (this.m_nestingDepth == this.m_namespaceDepth) {
                this.closeNamespaces();
            }
            this.m_textSeen = false;
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext textElement(int n, String string, String string2) throws JiBXException {
        try {
            this.indent();
            this.m_writer.write("<" + this.prefixText(n) + string + '>');
            this.writeContent(string2);
            this.m_writer.write("</" + this.prefixText(n) + string + '>');
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext intElement(int n, String string, int n2) throws JiBXException {
        try {
            this.indent();
            this.m_writer.write("<" + this.prefixText(n) + string + '>' + n2 + "</" + this.prefixText(n) + string + '>');
            return this;
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
    }

    public MarshallingContext marshalCollection(Collection collection) throws JiBXException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IMarshallable) {
                ((IMarshallable)e).marshal(this);
                continue;
            }
            throw new JiBXException("Unmarshallable object of class " + e.getClass() + " found in marshalling");
        }
        return this;
    }

    public MarshallingContext marshalCollection(ArrayList arrayList) throws JiBXException {
        int n = 0;
        while (n < arrayList.size()) {
            Object e = arrayList.get(n);
            if (!(e instanceof IMarshallable)) {
                throw new JiBXException("Unmarshallable object of class " + e.getClass().getName() + " found in marshalling");
            }
            ((IMarshallable)e).marshal(this);
            ++n;
        }
        return this;
    }

    public MarshallingContext marshalCollection(Vector vector) throws JiBXException {
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (!(e instanceof IMarshallable)) {
                throw new JiBXException("Unmarshallable object of class " + e.getClass().getName() + " found in marshalling");
            }
            ((IMarshallable)e).marshal(this);
            ++n;
        }
        return this;
    }

    public void addMarshalling(int n, IMarshaller iMarshaller) {
        this.m_marshallers[n] = iMarshaller;
    }

    public void removeMarshalling(int n) {
        this.m_marshallers[n] = null;
    }

    protected void closeNamespaces() {
        DeclarationInfo declarationInfo = (DeclarationInfo)this.m_namespaceStack.pop();
        int[] nArray = declarationInfo.m_deltas;
        String[] stringArray = declarationInfo.m_priors;
        int n = 0;
        while (n < nArray.length) {
            this.m_prefixes[nArray[n]] = stringArray[n];
            ++n;
        }
        this.m_namespaceDepth = this.m_namespaceStack.empty() ? -1 : ((DeclarationInfo)this.m_namespaceStack.peek()).m_depth;
    }

    public MarshallingContext startTagNamespaces(int n, String string, int[] nArray, String[] stringArray) throws JiBXException {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray.length) {
            if (!stringArray[n5].equals(this.m_prefixes[nArray[n5]])) {
                ++n4;
            }
            ++n5;
        }
        int[] nArray2 = null;
        if (n4 > 0) {
            int n6;
            String[] stringArray2 = new String[n4];
            if (n4 == nArray.length) {
                nArray2 = nArray;
                n3 = 0;
                while (n3 < n4) {
                    n6 = nArray2[n3];
                    stringArray2[n3] = this.m_prefixes[n6];
                    this.m_prefixes[n6] = stringArray[n3];
                    ++n3;
                }
            } else {
                n3 = 0;
                nArray2 = new int[n4];
                n6 = 0;
                while (n6 < nArray.length) {
                    n2 = nArray[n6];
                    if (!stringArray[n6].equals(this.m_prefixes[n2])) {
                        nArray2[n3] = n2;
                        stringArray2[n3++] = this.m_prefixes[n2];
                        this.m_prefixes[n2] = stringArray[n6];
                    }
                    ++n6;
                }
            }
            this.m_namespaceStack.push(new DeclarationInfo(this.m_nestingDepth, nArray2, stringArray2));
            this.m_namespaceDepth = this.m_nestingDepth;
        }
        this.startTagAttributes(n, string);
        try {
            int n7 = 0;
            while (n7 < n4) {
                n3 = nArray2[n7];
                String string2 = this.m_prefixes[n3];
                n2 = string2.length();
                if (n2 > 0) {
                    this.m_writer.write(" xmlns:" + string2.substring(0, n2 - 1) + "=\"");
                } else {
                    this.m_writer.write(" xmlns=\"");
                }
                this.writeAttribute(this.m_uris[n3]);
                this.m_writer.write(34);
                ++n7;
            }
        }
        catch (IOException iOException) {
            throw new JiBXException("Error writing marshalled document", iOException);
        }
        return this;
    }

    public IMarshaller getMarshaller(int n, String string) throws JiBXException {
        if (n > this.m_classes.length || !string.equals(this.m_classes[n])) {
            throw new JiBXException("Marshalling not defined for class " + string);
        }
        return this.m_marshallers[n];
    }

    protected void marshalRoot(Object object) throws JiBXException {
        if (!(object instanceof IMarshallable)) {
            throw new JiBXException("Supplied root object of class " + object.getClass().getName() + " cannot be marshalled without top-level mapping");
        }
        ((IMarshallable)object).marshal(this);
    }

    public void marshalDocument(Object object, String string, Boolean bl) throws JiBXException {
        this.startDocument(string, bl);
        this.marshalRoot(object);
        this.endDocument();
    }

    public void marshalDocument(Object object, String string, Boolean bl, OutputStream outputStream) throws JiBXException {
        this.startDocument(string, bl, outputStream);
        this.marshalRoot(object);
        this.endDocument();
    }

    public void marshalDocument(Object object, String string, Boolean bl, Writer writer) throws JiBXException {
        this.startDocument(string, bl, writer);
        this.marshalRoot(object);
        this.endDocument();
    }

    private static class DeclarationInfo {
        public final int m_depth;
        public final int[] m_deltas;
        public final String[] m_priors;

        public DeclarationInfo(int n, int[] nArray, String[] stringArray) {
            this.m_depth = n;
            this.m_deltas = nArray;
            this.m_priors = stringArray;
        }
    }
}

