/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.provider;


import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.zuena.guiceex.exception.ProviderException;

import com.google.inject.Provider;

/**
 * vpeBt@C[h{@link Properties}CX^X񋟂{@link Provider}
 * NXłB
 * @auther matsu@zuena.org
 * @since 0.9.1
 */
public abstract class CustomPropertiesProvider implements Provider<Properties> {

	final protected String path;
	final protected boolean xml;
	
	public CustomPropertiesProvider(String path, boolean xml) {
		this.path = path;
		this.xml = xml;
	}
	
	public Properties get() {
		Properties properties = new Properties();
		try {
			InputStream is = getInputStream();
			if (xml){
				properties.loadFromXML(is);
			}else{
				properties.load(is);
			}
			return properties;
		} catch (IOException e) {
			throw new ProviderException(e);
		}
	}

	protected abstract InputStream getInputStream();
}
