/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.matcher;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.google.inject.matcher.AbstractMatcher;

/**
 * <code>java.util.regex</code>gpK\ɂ}b`O
 * {@link com.google.inject.matcher.Matcher}NXłB
 * {@link com.google.inject.matcher.Matcher#and(com.google.inject.matcher.Matcher)}
 * {@link com.google.inject.matcher.Matcher#or(com.google.inject.matcher.Matcher)}
 * 邽߂{@link AbstractMatcher}gĂ܂B
 * @auther matsu@zuena.org
 * @since 0.9.1
 */
public class RegexMatcher extends AbstractMatcher {

	private Pattern pattern = null;
	
	public RegexMatcher(String regex) {
		this.pattern = Pattern.compile(regex);
	}
	public boolean matches(Object t) {
		String name = null;
		if (t instanceof Class){
			name = ((Class)t).getName();
		}else if (t instanceof Method){
			name = ((Method)t).getName();
		}else{
			throw new IllegalArgumentException();
		}
		Matcher matcher = pattern.matcher(name);
		return matcher.matches()
				|| matcher.lookingAt()
				|| matcher.find();
	}

}
