/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.jpa;

import java.util.LinkedHashMap;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.jpa.utils.JPASupportUtils;

/**
 * XbhɁA<code>unitName</code>L[{@link EntityManager}CX^XǗ܂B
 * ܂Aw肳ꂽ<code>unitName</code>ɉ{@link EntityManager}𑀍삷郁\bh񋟂܂B
 * @auther matsu@zuena.org
 * @since 0.9.1
 */
public class EntityManagerManager {

	private static final Log log = LogFactory.getLog(EntityManagerManager.class);
	private static ThreadLocal<Map<String,EntityManager>> ems = new ThreadLocal<Map<String,EntityManager>>(){
		protected java.util.Map<String,EntityManager> initialValue() {
			return new LinkedHashMap<String, EntityManager>();
		};
	};

	/**
	 * {@link EntityManager}CX^XVK쐬܂B
	 * gUNV̊Jn͍s܂B
	 */
	public static EntityManager createNewEntityManager(PersistenceContext pc){
		return  createNewEntityManager(pc.unitName()
							, JPASupportUtils.persistencePropertiesToMap(pc.properties()));

	}

	/**
	 * {@link EntityManager}CX^XVK쐬܂B
	 * gUNV̊Jn͍s܂B
	 */
	public static EntityManager createNewEntityManager(String unitName,Map param){
		EntityManager em =  EntityManagerFactoryHolder.getEntityManagerFactory(unitName, param)
														.createEntityManager();
		if (log.isDebugEnabled()){
			log.debug("create new EntityManager[" + em + "] for unitName["+unitName+"]");
		}
		return em;
	}
	
	/**
	 * ݂{@link EntityManager}CX^X擾܂B
	 */
	public static EntityManager getCurrentEntityManager(String unitName){
		return ems.get().get(unitName);
	}

	/**
	 * ݂{@link EntityManager}CX^Xɐݒ肵܂B
	 * ȑOɐݒ肳Ă{@link EntityManager}CX^Xԋp܂B
	 */
	public static EntityManager setCurrentEntityManager(String unitName,EntityManager newEm){
		EntityManager oldEm = ems.get().get(unitName);
		ems.get().put(unitName, newEm);
		if (log.isDebugEnabled()){
			log.debug("set unitName["+unitName+"] old[" + oldEm + "] to new["+newEm+"]");
		}
		return oldEm;
	}

	/**
	 * ݂{@link EntityManager}CX^X̃gUNVJn܂B
	 */
	public static void beginTransaction(String unitName){
		EntityManager em =  ems.get().get(unitName);;
		if (em == null){
			throw new UnsupportedOperationException();
		}
		assert(ems != null && !ems.get().get(unitName).getTransaction().isActive());
		em.getTransaction().begin();
		if (log.isDebugEnabled()){
			log.debug("begin transaction");
		}
	}
	
	/**
	 * ݂{@link EntityManager}CX^X̃gUNVR~bg܂B
	 */
	public static void commitCurrentEm(String unitName) {
		if (log.isDebugEnabled()){
			log.debug("commit  unitName["+unitName+"] em["+ems.get().get(unitName)+"]");
		}
		assert(ems.get() != null && ems.get().get(unitName).getTransaction().isActive());
		try{
			ems.get().get(unitName).getTransaction().commit();
		}catch(Throwable e){
		}
	}

	/**
	 * ݂{@link EntityManager}CX^X̃gUNV[obN܂B
	 */
	public static void rollbackCurrentEntityManager(String unitName) {
		if (log.isDebugEnabled()){
			log.debug("rollback  unitName["+unitName+"] em["+ems.get().get(unitName)+"]");
		}
		assert(ems.get() != null && ems.get().get(unitName).getTransaction().isActive());
		try{
			ems.get().get(unitName).getTransaction().rollback();
		}catch(Throwable e){
		}
	}

	/**
	 * ݂{@link EntityManager}CX^XN[Y܂B
	 */
	public static void closeCurrentEntityManager(String unitName) {
		if (log.isDebugEnabled()){
			log.debug("close  unitName["+unitName+"] em["+ems.get().get(unitName)+"]");
		}
		assert(ems.get() != null && ems.get().get(unitName).isOpen());
		try{
			ems.get().get(unitName).close();
		}catch(Throwable e){
		}
		ems.get().put(unitName, null);
	}
}

