/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.binder;




import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.zuena.guiceex.exception.BindException;

import com.google.inject.Binder;
import com.google.inject.spring.SpringIntegration;

/**
 * guiceex-config&lt;spring&gt;Ɏw肳ꂽSpringFrameworkƂ̓sNXłB
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public class SpringBinder implements GuiceexBinder{

	private String classPath = null;
	private String filePath = null;
	
	public void bind(Binder binder)  {
		
		ApplicationContext context = null;
		if (classPath != null){
			context = new ClassPathXmlApplicationContext(classPath);
		}else if (filePath  != null){
			context = new FileSystemXmlApplicationContext(filePath);
		}else{
			throw new BindException("applicationContext.xml path is must specified");
		}
		SpringIntegration.bindAll(binder, context);
	}

	public void setClassPath(String classPath) {
		this.classPath = classPath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

}
