package org.zuena.guiceex.jpa.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;

@Entity
public class Dept implements Serializable {
	@Id
	private BigDecimal deptno;

	private String loc;

	private String dname;

	@OneToMany(mappedBy="deptno")
	private Set<Emp> empCollection;

	private static final long serialVersionUID = 1L;

	public Dept() {
		super();
	}

	public BigDecimal getDeptno() {
		return this.deptno;
	}

	public void setDeptno(BigDecimal deptno) {
		this.deptno = deptno;
	}

	public String getLoc() {
		return this.loc;
	}

	public void setLoc(String loc) {
		this.loc = loc;
	}

	public String getDname() {
		return this.dname;
	}

	public void setDname(String dname) {
		this.dname = dname;
	}

	public Set<Emp> getEmpCollection() {
		return this.empCollection;
	}

	public void setEmpCollection(Set<Emp> empCollection) {
		this.empCollection = empCollection;
	}

}
