package org.zuena.guiceex.jpa;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.zuena.guiceex.transaction.annotation.Transactional;


import static org.zuena.guiceex.transaction.TransactionAttributeType.*;

/**
 * @author matsu@zuena.org.
 */
public class TransactionalProcess {


	@PersistenceContext(unitName="hsql")
	public EntityManager entityManager;
	
	public TransactionalProcess() {
	}

	@Transactional(NOT_SUPPORTED)
	public void notSupported(EntityManager em) {
		if (entityManager == null){
			throw new RuntimeException("EntityManagernull");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActivełȂ");
		}
	}

	@Transactional(SUPPORTS)
	public void supprots(EntityManager em) {
		if (entityManager == null){
			throw new RuntimeException("EntityManagernull");
		}
		if (em != null && em != entityManager){
			throw new RuntimeException("gUNVpłȂ");
		}
	}

	@Transactional(REQUIRED)
	public void required(EntityManager em) {
		if (entityManager == null){
			throw new RuntimeException("EntityManagernull");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveł͂Ȃ");
		}
		if (em != null
			&& em.getTransaction().isActive()
			&& em != entityManager){
			throw new RuntimeException("ActivegUNVpłȂ");
		}
	}

	@Transactional(REQUIRES_NEW)
	public void requiresNew(EntityManager em) {
		if (entityManager == null){
			throw new RuntimeException("EntityManagernull");
		}
		if (em == entityManager){
			throw new RuntimeException("VKgUNVJnĂȂ");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveł͂Ȃ");
		}
	}

	@Transactional(MANDATORY)
	public void mandatory(EntityManager em) {
		if (entityManager == null){
			throw new RuntimeException("EntityManagernull");
		}
		if (!entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveł͂Ȃ");
		}
		if (em == null){
			throw new RuntimeException("NoTransactionExceptionX[ĂȂ");
		}
	}

	@Transactional(NEVER)
	public void never(EntityManager em) {
		if (entityManager == null){
			throw new RuntimeException("EntityManagernull");
		}
		if (entityManager.getTransaction().isActive()){
			throw new RuntimeException("gUNVActiveł͂Ȃ");
		}
		if (em != null && em.getTransaction().isActive()){
			throw new RuntimeException("TransactionActiveExceptionX[ĂȂ");
		}
	}

}
