package org.zuena.guiceex.jpa;



import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceProperty;

import org.zuena.guiceex.GuiceexInjector;
import org.zuena.guiceex.InjectorFactory;
import org.zuena.guiceex.transaction.TransactionAttributeType;
import org.zuena.guiceex.transaction.annotation.Transactional;




import junit.framework.TestCase;




public class TestTransactionInterceptor  extends TestCase{

	static 	GuiceexInjector injector = null;
	
	@Override
	protected void setUp() throws Exception {
		super.setUp();
		injector = InjectorFactory.getInjector();
	}
	
	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
		injector.close();
	}
	/**
	 * {@code @}{@link Transactional}gpĂȂNCAǧĂяoeXg
	 * gUNV̈poOŗOB
	 * EntityManagerThreadɍ쐬Ă鎖̓OŊmF
	 */
	public void test1() {
		TestRunner r1 = new TestRunner();
		TestRunner r2 = new TestRunner();
		Thread t1 = new Thread(r1);
		Thread t2 = new Thread(r2);
		t1.start();
		t2.start();
		while(t1.isAlive() || t2.isAlive()){
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		if (r1.t != null){
			r1.t.printStackTrace();
			fail();
		}
		if (r2.t != null){
			r2.t.printStackTrace();
			fail();
		}
		System.out.println("end");
	}
	
	/**
	 * lXggUNṼeXg
	 * gUNV̈poOŗOB
	 */
	public void test2(){
		TestRunner2 r1 = new TestRunner2();
		TestRunner2 r2 = new TestRunner2();
		Thread t1 = new Thread(r1);
		Thread t2 = new Thread(r2);
		t1.start();
		t2.start();
		while(t1.isAlive() || t2.isAlive()){
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		if (r1.t != null){
			r1.t.printStackTrace();
			fail();
		}
		if (r2.t != null){
			r2.t.printStackTrace();
			fail();
		}
		System.out.println("end");
	}
	
	/**
	 * EntityManager̒eXgB
	 * pKw̓ꃁ\bhɎw肳ꂽ@Transactional̃I[o[Ch̃eXgB
	 * @PersistenceContext#properties̃eXgisqltH[}bgăOo͂ȂAOŊmFj
	 * oO͗Oŕ
	 */
	public void test3(){
		
		TestSubClass t = injector.getInstance(TestSubClass.class);
		t.method();
	}

	
	public static class TestSuperClass{
		
		@PersistenceContext(unitName="hsql"
			,properties={
				@PersistenceProperty(name="hibernate.format_sql",value="false")
				,@PersistenceProperty(name="show_sql",value="false")
		}
		)
		private EntityManager em;//
		
		@Transactional(TransactionAttributeType.REQUIRED)
		public void method(){
			if (em == null){
				throw new RuntimeException("EntityManager inject error");
			}
			if (em.getTransaction().isActive()){
				throw new RuntimeException("@TransactionalI[o[ChĂȂ");
			}
			em.createNativeQuery("select * from customer").getResultList();
		}
		final public EntityManager getSuperClassEntityManager(){
			return em;
		}
	}

	public static class TestSubClass extends TestSuperClass{
		
		@PersistenceContext(unitName="hsql")
		private EntityManager em;//Ȃ
		
		@Transactional(TransactionAttributeType.NEVER)
		public void method(){
			if (em != null){
				throw new RuntimeException("EntityManager inject error");
			}
			super.method();
		}
		final public EntityManager getSubClassEntityManager(){
			return em;
		}
	}
}
