/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.jpa;

import javax.persistence.EntityManager;

import org.zuena.guiceex.InjectorFactory;
import org.zuena.guiceex.transaction.NoTransactionException;

/**
 * @author matsu@zuena.org.
 */
public class TestRunner implements Runnable{
	public Throwable t = null;
	
	public void run() {
		try{
			EntityManager em = null;
			TransactionalProcess p = InjectorFactory.getInjector().getInstance(TransactionalProcess.class);

			// EntityManager쐬̏Ԃ
			// NOT_SUPPORTw肳ꂽꍇB
			p.notSupported(null);
			em = EntityManagerManager.getCurrentEntityManager("hsql");
			if (em != null){
				throw new Throwable("EntityManagerN[YĂȂ");
			}

			// EntityManager쐬̏Ԃ
			// SUPPORTSw肳ꂽꍇB
			p.supprots(null);
			em = EntityManagerManager.getCurrentEntityManager("hsql");
			if (em != null){
				throw new Throwable("EntityManagerN[YĂȂ");
			}

			// EntityManager쐬̏Ԃ
			// REQUIREDw肳ꂽꍇ
			p.required(null);
			em = EntityManagerManager.getCurrentEntityManager("hsql");
			if (em != null){
				throw new Throwable("EntityManagerN[YĂȂ");
			}
		
			// EntityManager쐬̏Ԃ
			// REQUIRES_NEWw肳ꂽꍇ
			p.requiresNew(null);
			em = EntityManagerManager.getCurrentEntityManager("hsql");
			if (em != null){
				throw new Throwable("EntityManagerN[YĂȂ");
			}

			// EntityManager쐬̏Ԃ
			// MANDANTORYw肳ꂽꍇ
			try{
				p.mandatory(null);
				throw new Throwable("NoTransactionExceptionX[ĂȂ");
			}catch(NoTransactionException e){
				// ok
			}
			if (em != null){
				throw new Throwable("EntityManagerN[YĂȂ");
			}
			em = EntityManagerManager.getCurrentEntityManager("hsql");
			if (em != null){
				throw new Throwable("EntityManagerN[YĂȂ");
			}
			
			// EntityManager쐬̏Ԃ
			// NEVERw肳ꂽꍇ
			p.never(null);
			em = EntityManagerManager.getCurrentEntityManager("hsql");
			if (em != null){
				throw new Throwable("EntityManagerN[YĂȂ");
			}
			
		}catch(Throwable t){
			this.t = t;
		}
	}
}
