/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.transaction.annotation;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;


import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.zuena.guiceex.transaction.TransactionAttributeType;

import com.google.inject.BindingAnnotation;

/**
 * {@link org.zuena.guiceex.jpa.transaction.TransactionInterceptor}oCh\bh
 * ߂Ame[VłB
 * @auther matsu@zuena.org
 * @since 0.9.1
 */

@Retention(RUNTIME)
@Target(METHOD)
@BindingAnnotation
public @interface Transactional{
	TransactionAttributeType value() default TransactionAttributeType.REQUIRED;
	String unitName() default "";
	Class<? extends Throwable>[] rollbackFor() default {Throwable.class};
}
