/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.jpa;


import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.zuena.guiceex.jpa.exception.PersistenceXmlParseException;
import org.zuena.guiceex.jpa.utils.JPASupportUtils;
import org.zuena.guiceex.util.StringUtils;





/**
 * {@link EntityManagerFactory}CX^XێNXłB<br/>
 * &lt;persistence-unit&gt;nameL[ɁAjbgɑΉ{@link EntityManagerFactory}CX^X
 * statictB[hɍ쐬{@link Map}CX^XŊǗ܂B
 * persistence.xmlɂP&lt;persistence-unit&gt;̂ݒ`Ăꍇ̓jbg̏ȗ\łB
 * &lt;persistence-unit&gt;`ĂԂŃjbgȗ{@link PersistenceException}
 * X[܂B
 * @auther matsu@zuena.org
 * @since 0.9.1
 */
@SuppressWarnings("unchecked")
public class EntityManagerFactoryHolder {
	private static final Map<String, PersistenceUnit> emfs 
											= new HashMap<String, PersistenceUnit>();

	/**
	 * persistence.xmlpersistence-unti\NXłB
	 * @author matsu@zuena.org.
	 */
	public static class PersistenceUnit{
		private String name;
		private String transactionType = null;
		private EntityManagerFactory entityManagerFactory = null;
		public PersistenceUnit() {}
		public EntityManagerFactory getEntityManagerFactory() {
			return entityManagerFactory;
		}
		public void setEntityManagerFactory(EntityManagerFactory factory) {
			this.entityManagerFactory = factory;
		}
		public String getName() {
			return name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getTransactionType() {
			return transactionType;
		}
		public void setTransactionType(String transactionType) {
			this.transactionType = transactionType;
		}
		
	}
	
	static class  Handler extends DefaultHandler{
		@Override
		public void startElement(String uri
								, String localName
								, String qName
								, Attributes attributes) throws SAXException {
			if ("persistence-unit".equals(qName)){
				PersistenceUnit pu = new PersistenceUnit();
				int index = attributes.getIndex("name");
				pu.name = attributes.getValue(index);
				index = attributes.getIndex("transaction-type");
				pu.transactionType = attributes.getValue(index);
				emfs.put(pu.name,pu);
			}
		}
	}
	
	/**
	 * META-INF/persistence.xmlǂݍŁA`𓾂܂B
	 * ̃\bh{@link JPASupportUtils#initialize()}Ăяo܂B
	 */
	public static void initialize(){

		try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            DefaultHandler handler = new Handler();
            InputStream is = Thread.currentThread()
									.getContextClassLoader()
									.getResourceAsStream("META-INF/persistence.xml");
            if (is != null){
                parser.parse(is,handler);
            }
										
		} catch (Exception e) {
			throw new PersistenceXmlParseException(e);
		}
		if (emfs.size() == 0){
			throw new PersistenceXmlParseException("persistence-unit not found");
		}
	}

	/**
 	 * {@link EntityManagerFactory}̃t@Ng\bhłB 
 	 * <code>unitName</code>ɉ{@link EntityManagerFactory}CX^XA
 	 * KvɉĐVK쐬ĕԋp܂B
	 */
	public static  EntityManagerFactory getEntityManagerFactory(String unitName,Map map){
		String name = getPersistenceUnitName(unitName);
		EntityManagerFactory emf = null;
		PersistenceUnit pu = emfs.get(name);
		if (pu == null){
			throw new IllegalArgumentException("persistence-unit name='" + name + "' is not found");
		}
		synchronized(pu){
			emf = pu.getEntityManagerFactory();
			if (emf == null){
				emf = Persistence.createEntityManagerFactory(name,map);
				pu.setEntityManagerFactory(emf);
			}
		}		
		return emf;
	}
	
	/**
	 * <code>unitName</code>ɉ{@link PersistenceUnit}CX^Xԋp܂B
	 */
	public static PersistenceUnit getPersistenceUnit(String unitName){
		return emfs.get(getPersistenceUnitName(unitName));
	}
	
	/**
	 * SĂ{@link EntityManagerFactory}CX^X{@link EntityManagerFactory#close()}
	 * ĂяoăN[Y܂B
	 */
	public static synchronized void closeAll(){
		for (Map.Entry<String, PersistenceUnit> entry : emfs.entrySet()) {
			EntityManagerFactory emf = entry.getValue().getEntityManagerFactory();
			if (emf != null && emf.isOpen()){
				emf.close();
			}
		}
		emfs.clear();
	}
	
	private static String getPersistenceUnitName(String unitName){
		String name = unitName;
		if (StringUtils.isEmpty(name)){
			if (emfs.size() > 1){
				throw new PersistenceException("unitName is requited when multiple persistence-unit defined");
			}
			name = emfs.entrySet().iterator().next().getValue().getName();
		}
		return name;
	}
}
