/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.config;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.transaction.TransactionAttributeType;
import org.zuena.guiceex.provider.SystemPropertiesProvider;
import org.zuena.guiceex.scope.Scopes;
import org.zuena.guiceex.transaction.annotation.Transactionals;


import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import com.google.inject.name.Names;

/**
 * guiceexɃohĂoCfBOݒ܂B
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public class BundleModule extends AbstractModule {

	private static final Log log = LogFactory.getLog(BundleModule.class);
	
	/* (non-Javadoc)
	 * @see com.google.inject.AbstractModule#configure()
	 */
	@Override
	protected void configure() {
		if (log.isDebugEnabled()){
			log.debug("binding for Guiceex bundle mods...");
		}
		bindScopes();
		bindDefault();
		bindInterceptors();
		if (log.isDebugEnabled()){
			log.debug("end of binding for Guiceex bundle mods...");
		}
	}

	private void bindDefault() {
		
		bind(Properties.class)
			.annotatedWith(Names.named("system"))
			.toProvider(SystemPropertiesProvider.class)
			.in(Singleton.class);
	}

	private void bindScopes() {
		if (log.isDebugEnabled()){
			log.debug("binding bundle scopes...");
		}
		bindScope(org.zuena.guiceex.scope.ThreadLocalScope.class, Scopes.THREAD_LOCAL);
	}

	private void bindInterceptors(){
		if (log.isDebugEnabled()){
			log.debug("binding bundle interceptors...");
		}
		for (TransactionAttributeType propagationType : TransactionAttributeType.values()) {
			Transactionals.bindTransactionInterceptor(
					binder()
					, propagationType);
		}
	}
}

