/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.binder;

import java.util.ArrayList;
import java.util.List;


import org.zuena.guiceex.config.Collection;
import org.zuena.guiceex.config.Entry;
import org.zuena.guiceex.exception.BindException;
import org.zuena.guiceex.provider.ListProvider;
import org.zuena.guiceex.provider.MapProvider;
import org.zuena.guiceex.util.ClassUtils;


import com.google.inject.Provider;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;

/**
 * guiceex-config̃oC_[vf<code>toType</code>̐ݒsNXłB
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public abstract class ToBinder extends ScopedBinder {

	@SuppressWarnings("unchecked")
	protected void bindTo(LinkedBindingBuilder binder){
		
		if (getCollection() != null){
			bindIn(bindCollectionProvider(binder));
			return;
		}else if (getToInstance() != null){
			binder.toInstance(getToInstance());
			return;
		}

		ScopedBindingBuilder builder = null;

		if (getToType() != null){
			builder = binder.to(
						ClassUtils.cast(
								ClassUtils.getClazz(getType())
								, ClassUtils.getClazz(getToType())));
		}else if (getToProviderInstance() != null){
			builder = binder.toProvider(getToProviderInstance());
		}else if (getToProviderType() != null){
			builder = binder.to(
					ClassUtils.getClazz(getToProviderType()));
		}else{
			throw new BindException("'to' type not specified");
		}
		bindIn(builder);
	}

	@SuppressWarnings("unchecked")
	protected ScopedBindingBuilder bindCollectionProvider(LinkedBindingBuilder binder){
		Collection collection = getCollection();
		List<Entry> entries = new ArrayList<Entry>();
		Provider provider = null;
		entries.addAll(collection.getEntries());
		if (collection.isMap()){
			provider = new MapProvider(entries,ClassUtils.getClazz(collection.getType()));
		}else if (collection.isList()){
			provider = ListProvider.fromList(entries,ClassUtils.getClazz(collection.getType()));
		}else{
			throw new BindException("unsupport collection type '" + collection.getType() + "'");
		}
		return binder.toProvider(provider);
			
	}
}
