/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.binder;


import java.util.Properties;

import org.zuena.guiceex.provider.ClassPathPropertiesProvider;
import org.zuena.guiceex.provider.FileSystemPropertiesProvider;
import org.zuena.guiceex.provider.SystemPropertiesProvider;

import com.google.inject.Binder;


/**
 * guiceex-config&lt;properties&gt;Ɏw肳ꂽoCfBOݒsoC_[NXłB
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public class PropertiesBinder extends NameBinder {

	private String classPath = null;
	private String filePath = null;
	private boolean system;
	private boolean xml;
	
	/* (non-Javadoc)
	 * @see org.zuena.guiceex.config.GuiceexBinder#bind(com.google.inject.Binder)
	 */
	public void bind(Binder binder) {
		setType(Properties.class.getName());
		setToType(null);
		setToInstance(null);
		
		if (isSystem()){
			setToProviderType(SystemPropertiesProvider.class.getName());
		}else if (filePath != null) {
			setToProviderInstance(new FileSystemPropertiesProvider(filePath,xml));
		}else if (classPath != null){
			setToProviderInstance(new ClassPathPropertiesProvider(classPath,xml));
		}
		super.bind(binder);
	}

	public String getClassPath() {
		return classPath;
	}

	public void setClassPath(String classPath) {
		this.classPath = classPath;
	}

	public String getFilePath() {
		return filePath;
	}

	public void setFilePath(String filePath) {
		this.filePath = filePath;
	}

	public boolean isSystem() {
		return system;
	}

	public void setSystem(boolean system) {
		this.system = system;
	}

	public boolean isXml() {
		return xml;
	}

	public void setXml(boolean xml) {
		this.xml = xml;
	}

}
