/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.binder;


import org.zuena.guiceex.util.ClassUtils;

import com.google.inject.Binder;
import com.google.inject.binder.AnnotatedConstantBindingBuilder;
import com.google.inject.binder.ConstantBindingBuilder;

/**
 * guiceex-config&lt;constant&gt;֎w肳ꂽoCfBOݒsoC_[NXłB
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public class ConstantBinder extends BasicBinderSupport implements GuiceexBinder {

	@SuppressWarnings("unchecked")
	public void bind(Binder binder)  {
		AnnotatedConstantBindingBuilder builder = binder.bindConstant();
		ConstantBindingBuilder cbuilder = builder.annotatedWith(ClassUtils.getClazz(getAnnotationType()));
		cbuilder.to(getValue());
	}
}
