/**
 * Copyright  2007 matsu@zuena.org.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except scopeType compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed toType scopeType writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.zuena.guiceex.binder;

import org.zuena.guiceex.config.Collection;

import com.google.inject.Provider;



/**
 * {@link GuiceexBinder}NXŋʓIɎgpvpeB񋟂܂B<br/>
 * guiceex-config&lt;buind&gt;A&lt;annotation&gt;A&lt;name&gt;A&lt;constant&gt;A
 * y&lt;propertiesgt&gt;̋ʑ܂B
 * @auther matsu@zuena.org.
 * @since 0.9.1
 */
public abstract class BasicBinderSupport implements GuiceexBinder{
	private String type = null;
	private String id = null;
	private String annotationType = null;
	private String toType = null;
	private String toProviderType = null;
	private String constant = null;
	private String scopeType = null;
	private boolean preload = false;
	private Collection collection = null;
	private String value = null;
	private Object toInstance = null;
	private Provider toProviderInstance = null;
	
	public BasicBinderSupport() {
	}
	
	public String getAnnotationType() {
		return annotationType;
	}
	
	public void setAnnotationType(String annotationWith) {
		this.annotationType = annotationWith;
	}
	
	public String getScopeType() {
		return scopeType;
	}
	
	public void setScopeType(String in) {
		this.scopeType = in;
	}
	
	public String getToType() {
		return toType;
	}
	
	public void setToType(String to) {
		this.toType = to;
	}
	
	public String getType() {
		return type;
	}
	
	public void setType(String type) {
		this.type = type;
	}
	
	public String getId() {
		return id;
	}
	
	public void setId(String name) {
		this.id = name;
	}
	
	public boolean isPreload() {
		return preload;
	}
	
	public void setPreload(boolean preload) {
		this.preload = preload;
	}
	
	public String getConstant() {
		return constant;
	}
	
	public void setConstant(String constant) {
		this.constant = constant;
	}
	
	public Collection getCollection() {
		return collection;
	}
	
	public void setCollection(Collection collection) {
		this.collection = collection;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getToProviderType() {
		return toProviderType;
	}

	public void setToProviderType(String toProviderType) {
		this.toProviderType = toProviderType;
	}

	public Object getToInstance() {
		return toInstance;
	}

	public void setToInstance(Object toInstance) {
		this.toInstance = toInstance;
	}

	public Provider getToProviderInstance() {
		return toProviderInstance;
	}

	public void setToProviderInstance(Provider toProviderInstance) {
		this.toProviderInstance = toProviderInstance;
	}

	public String toString(){
		return getClass().getName()  
					+ ":type=[" + type + "]"
					+ ",id=[" + id + "]"
					+ ",annotationType=[" + annotationType + "]"
					+ ",toType=[" + toType + "]"
					+ ",toProviderType=[" + toProviderType + "]"
					+ ",constant=[" + constant + "]"
					+ ",scopeType=[" + scopeType + "]"
					+ ",preload=[" + preload + "]"
					+ ",value=[" + value + "]"
					+ ",toInstance=[" + toInstance + "]"
					+ ",collection=[" + collection + "]";
	}
}
