/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex.jpa.transaction;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.jpa.EntityManagerManager;
import org.zuena.guiceex.transaction.NoTransactionException;
import org.zuena.guiceex.transaction.TransactionActiveException;
import org.zuena.guiceex.transaction.TransactionAttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransactionPropagator
implements Cloneable {
    protected static final Log log = LogFactory.getLog(TransactionPropagator.class);
    protected static final Map<TransactionAttributeType, TransactionPropagator> propagators = new HashMap<TransactionAttributeType, TransactionPropagator>();
    protected Class<? extends Throwable>[] rollbackFor = null;
    protected TransactionAttributeType type = null;
    protected PersistenceContext pc;

    static {
        propagators.put(TransactionAttributeType.NOT_SUPPORTED, new TransactionPropagator(TransactionAttributeType.NOT_SUPPORTED){
            EntityManager oldEm = null;
            boolean entityManagerCreated = false;

            protected void prepare() {
                this.oldEm = EntityManagerManager.getCurrentEntityManager(this.pc.unitName());
                if (this.oldEm == null || this.oldEm != null && this.oldEm.getTransaction().isActive()) {
                    EntityManager em = EntityManagerManager.createNewEntityManager(this.pc);
                    EntityManagerManager.setCurrentEntityManager(this.pc.unitName(), em);
                    this.entityManagerCreated = true;
                }
            }

            protected void commitProcess() {
            }

            protected void rollbackProcess() {
            }

            protected void closeProcess() {
                if (this.entityManagerCreated) {
                    EntityManagerManager.closeCurrentEntityManager(this.pc.unitName());
                    EntityManagerManager.setCurrentEntityManager(this.pc.unitName(), this.oldEm);
                }
            }
        });
        propagators.put(TransactionAttributeType.SUPPORTS, new TransactionPropagator(TransactionAttributeType.SUPPORTS){
            boolean entityManagerCreated = false;

            protected void prepare() {
                EntityManager em = EntityManagerManager.getCurrentEntityManager(this.pc.unitName());
                if (em == null) {
                    em = EntityManagerManager.createNewEntityManager(this.pc);
                    EntityManagerManager.setCurrentEntityManager(this.pc.unitName(), em);
                    this.entityManagerCreated = true;
                }
            }

            protected void commitProcess() {
            }

            protected void rollbackProcess() {
            }

            protected void closeProcess() {
                if (this.entityManagerCreated) {
                    EntityManagerManager.closeCurrentEntityManager(this.pc.unitName());
                    EntityManagerManager.setCurrentEntityManager(this.pc.unitName(), null);
                }
            }
        });
        propagators.put(TransactionAttributeType.REQUIRED, new TransactionPropagator(TransactionAttributeType.REQUIRED){
            private boolean entityManagerCreated = false;
            private boolean transactionActivated = false;

            protected void prepare() {
                EntityManager em = EntityManagerManager.getCurrentEntityManager(this.pc.unitName());
                if (em == null) {
                    em = EntityManagerManager.createNewEntityManager(this.pc);
                    EntityManagerManager.setCurrentEntityManager(this.pc.unitName(), em);
                    this.entityManagerCreated = true;
                }
                if (!em.getTransaction().isActive()) {
                    EntityManagerManager.beginTransaction(this.pc.unitName());
                    this.transactionActivated = true;
                }
            }

            protected void commitProcess() {
                if (!this.entityManagerCreated && !this.transactionActivated) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)((Object)((Object)TransactionAttributeType.REQUIRED) + ":#commitProcess()"));
                }
                EntityManagerManager.commitCurrentEm(this.pc.unitName());
            }

            protected void rollbackProcess() {
                if (!this.entityManagerCreated && !this.transactionActivated) {
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)((Object)((Object)TransactionAttributeType.REQUIRED) + ":#rollbackProcess()"));
                }
                EntityManagerManager.rollbackCurrentEntityManager(this.pc.unitName());
            }

            protected void closeProcess() {
                if (this.entityManagerCreated) {
                    EntityManagerManager.closeCurrentEntityManager(this.pc.unitName());
                }
            }
        });
        propagators.put(TransactionAttributeType.REQUIRES_NEW, new TransactionPropagator(TransactionAttributeType.REQUIRES_NEW){
            EntityManager oldEm = null;

            protected void prepare() {
                this.oldEm = EntityManagerManager.getCurrentEntityManager(this.pc.unitName());
                EntityManager newEm = EntityManagerManager.createNewEntityManager(this.pc);
                EntityManagerManager.setCurrentEntityManager(this.pc.unitName(), newEm);
                EntityManagerManager.beginTransaction(this.pc.unitName());
            }

            protected void commitProcess() {
                EntityManagerManager.commitCurrentEm(this.pc.unitName());
            }

            protected void rollbackProcess() {
                EntityManagerManager.rollbackCurrentEntityManager(this.pc.unitName());
            }

            protected void closeProcess() {
                EntityManagerManager.closeCurrentEntityManager(this.pc.unitName());
                EntityManagerManager.setCurrentEntityManager(this.pc.unitName(), this.oldEm);
            }
        });
        propagators.put(TransactionAttributeType.MANDATORY, new TransactionPropagator(TransactionAttributeType.MANDATORY){

            protected void prepare() {
                EntityManager em = EntityManagerManager.getCurrentEntityManager(this.pc.unitName());
                if (em == null || !em.getTransaction().isActive()) {
                    throw new NoTransactionException();
                }
            }

            protected void commitProcess() {
            }

            protected void rollbackProcess() {
            }

            protected void closeProcess() {
            }
        });
        propagators.put(TransactionAttributeType.NEVER, new TransactionPropagator(TransactionAttributeType.NEVER){
            boolean entityManagerCreated = false;

            protected void prepare() {
                EntityManager em = EntityManagerManager.getCurrentEntityManager(this.pc.unitName());
                if (em != null && em.getTransaction().isActive()) {
                    throw new TransactionActiveException();
                }
                if (em == null) {
                    em = EntityManagerManager.createNewEntityManager(this.pc);
                    EntityManagerManager.setCurrentEntityManager(this.pc.unitName(), em);
                    this.entityManagerCreated = true;
                }
            }

            protected void commitProcess() {
            }

            protected void rollbackProcess() {
            }

            protected void closeProcess() {
                if (this.entityManagerCreated) {
                    EntityManagerManager.closeCurrentEntityManager(this.pc.unitName());
                }
            }
        });
    }

    public TransactionPropagator(TransactionAttributeType type) {
        this.type = type;
    }

    public void setPersistenceContext(PersistenceContext pc) {
        this.pc = pc;
    }

    public static TransactionPropagator getTransactionPropagator(TransactionAttributeType type) {
        return propagators.get((Object)type);
    }

    public Object propagate(Process process) throws Throwable {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)((Object)((Object)this.type) + ":#prepare()"));
            }
            this.prepare();
            Object ret = process.execute(EntityManagerManager.getCurrentEntityManager(this.pc.unitName()));
            if (log.isDebugEnabled()) {
                log.debug((Object)((Object)((Object)this.type) + ":#commitProcess()"));
            }
            EntityManager em = EntityManagerManager.getCurrentEntityManager(this.pc.unitName());
            assert (em != null);
            if (em.getTransaction().isActive() && em.getTransaction().getRollbackOnly()) {
                this.rollbackProcess();
            } else {
                this.commitProcess();
            }
            Object object = ret;
            return object;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)((Object)((Object)this.type) + ":#exceptionProcess()"), t);
            }
            this.exceptionProcess(t);
            throw t;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)((Object)((Object)this.type) + ":#closeTransaction()"));
            }
            this.closeProcess();
        }
    }

    public void setRollbackFor(Class<? extends Throwable>[] rollbackFor) {
        this.rollbackFor = rollbackFor;
    }

    public TransactionPropagator clone() {
        try {
            return (TransactionPropagator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected void exceptionProcess(Throwable t) throws Throwable {
        Class<? extends Throwable>[] classArray = this.rollbackFor;
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class<? extends Throwable> throwable = classArray[n];
            if (throwable.isAssignableFrom(t.getClass())) {
                this.rollbackProcess();
                return;
            }
            ++n;
        }
        this.commitProcess();
    }

    protected abstract void prepare();

    protected abstract void commitProcess();

    protected abstract void rollbackProcess();

    protected abstract void closeProcess();

    public static interface Process {
        public Object execute(EntityManager var1) throws Throwable;
    }
}

