/*
 * Decompiled with CFR 0.152.
 */
package org.zuena.guiceex;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.zuena.guiceex.GuiceexInjector;
import org.zuena.guiceex.config.AutoBindingModule;
import org.zuena.guiceex.config.BundleModule;
import org.zuena.guiceex.config.Config;
import org.zuena.guiceex.exception.BindException;
import org.zuena.guiceex.exception.ConfigurationException;
import org.zuena.guiceex.impl.GuiceexInjectorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorFactory {
    private static Log log = LogFactory.getLog(InjectorFactory.class);
    private static GuiceexInjectorImpl injector = null;

    private InjectorFactory() {
    }

    public static GuiceexInjector createInjector(Object ... configs) throws ConfigurationException, BindException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("create new instance for key=[" + configs + "]"));
        }
        GuiceexInjectorImpl newInjector = new GuiceexInjectorImpl(Guice.createInjector(InjectorFactory.getModules(configs)));
        newInjector.initialize();
        return newInjector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GuiceexInjector getInjector(Object ... configs) throws ConfigurationException, BindException {
        Class<InjectorFactory> clazz = InjectorFactory.class;
        synchronized (InjectorFactory.class) {
            if (injector == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("create new instance for key=[" + configs + "]"));
                }
                injector = (GuiceexInjectorImpl)InjectorFactory.createInjector(configs);
                injector.setManaged(true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return injector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Class<InjectorFactory> clazz = InjectorFactory.class;
        synchronized (InjectorFactory.class) {
            if (injector != null) {
                injector.closeImpl();
                injector = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static List<Module> getModules(Object[] configs) {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add((Module)new BundleModule());
        if (configs.length > 0) {
            Object[] objectArray = configs;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object config = objectArray[n];
                if (config instanceof Module) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("add [" + config + "]"));
                    }
                    modules.add((Module)Module.class.cast(config));
                } else if (config instanceof String) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("add Module that loaded from guiceex-cfg.xml at [" + config + "]"));
                    }
                    modules.add((Module)new AutoBindingModule(Config.configure((String)String.class.cast(config)).getBinders()));
                } else {
                    throw new IllegalArgumentException(config + "is NOT instance of Module or classpath for guceex-cfg.xml");
                }
                ++n;
            }
        } else {
            Config config = Config.configure("guiceex-cfg.xml");
            if (config != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"add Module that loaded from org.zuena.guiceex-cfg.xml at default classpath");
                }
                modules.add((Module)new AutoBindingModule(config.getBinders()));
            }
        }
        return modules;
    }
}

