/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.impl.drda.ReEncodedInputStream;
import org.apache.derby.impl.jdbc.Util;

class EXTDTAInputStream
extends InputStream {
    private InputStream binaryInputStream = null;
    private boolean isEmptyStream;
    private ResultSet dataResultSet = null;
    private Blob blob = null;
    private Clob clob = null;

    private EXTDTAInputStream(ResultSet resultSet, int n, int n2) throws SQLException, IOException {
        this.dataResultSet = resultSet;
        this.isEmptyStream = !this.initInputStream(resultSet, n, n2);
    }

    public static EXTDTAInputStream getEXTDTAStream(ResultSet resultSet, int n, int n2) throws SQLException {
        try {
            int n3 = n2 | 1;
            return new EXTDTAInputStream(resultSet, n, n3);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    private static long getInputStreamLength(InputStream inputStream) throws SQLException {
        long l = 0L;
        if (inputStream == null) {
            return l;
        }
        try {
            while (true) {
                int n = inputStream.available();
                inputStream.skip(n);
                if (n != 0) {
                    l += (long)n;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            throw Util.javaException(iOException);
        }
        return l;
    }

    public int read() throws IOException {
        return this.binaryInputStream.read();
    }

    public int available() throws IOException {
        return this.binaryInputStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.binaryInputStream != null) {
                this.binaryInputStream.close();
            }
            this.binaryInputStream = null;
            Object var2_1 = null;
            this.blob = null;
            this.clob = null;
            this.dataResultSet = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.blob = null;
            this.clob = null;
            this.dataResultSet = null;
            throw throwable;
        }
    }

    public boolean equals(Object object) {
        return this.binaryInputStream.equals(object);
    }

    public int hashCode() {
        return this.binaryInputStream.hashCode();
    }

    public void mark(int n) {
        this.binaryInputStream.mark(n);
    }

    public boolean markSupported() {
        return this.binaryInputStream.markSupported();
    }

    public int read(byte[] byArray) throws IOException {
        return this.binaryInputStream.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.binaryInputStream.read(byArray, n, n2);
    }

    public void reset() throws IOException {
        this.binaryInputStream.reset();
    }

    public long skip(long l) throws IOException {
        return this.binaryInputStream.skip(l);
    }

    protected boolean isEmptyStream() {
        return this.isEmptyStream;
    }

    private boolean initInputStream(ResultSet resultSet, int n, int n2) throws SQLException, IOException {
        InputStream inputStream = null;
        try {
            if (n2 == 201) {
                this.blob = resultSet.getBlob(n);
                if (this.blob == null) {
                    boolean bl = false;
                    return bl;
                }
                inputStream = this.blob.getBinaryStream();
            } else if (n2 == 207) {
                block17: {
                    this.clob = resultSet.getClob(n);
                    if (this.clob != null) break block17;
                    boolean bl = false;
                    return bl;
                }
                try {
                    inputStream = new ReEncodedInputStream(this.clob.getCharacterStream());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException(unsupportedEncodingException.getMessage());
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException.getMessage());
                }
            }
            boolean bl = inputStream.read() > -1;
            inputStream.close();
            inputStream = null;
            if (bl) {
                this.openInputStreamAgain();
            }
            boolean bl2 = bl;
            return bl2;
        }
        catch (IllegalStateException illegalStateException) {
            throw Util.javaException(illegalStateException);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void openInputStreamAgain() throws IllegalStateException, SQLException {
        if (this.binaryInputStream != null) {
            return;
        }
        InputStream inputStream = null;
        try {
            if (this.blob != null) {
                inputStream = this.blob.getBinaryStream();
            } else if (this.clob != null) {
                inputStream = new ReEncodedInputStream(this.clob.getCharacterStream());
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.binaryInputStream = inputStream;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

