/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.util.Properties;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttributeSource;

public class TransactionInterceptor
extends TransactionAspectSupport
implements MethodInterceptor {
    public TransactionInterceptor() {
    }

    public TransactionInterceptor(PlatformTransactionManager ptm, Properties attributes) {
        this.setTransactionManager(ptm);
        this.setTransactionAttributes(attributes);
    }

    public TransactionInterceptor(PlatformTransactionManager ptm, TransactionAttributeSource tas) {
        this.setTransactionManager(ptm);
        this.setTransactionAttributeSource(tas);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?> targetClass = invocation.getThis() != null ? invocation.getThis().getClass() : null;
        TransactionAspectSupport.TransactionInfo txInfo = this.createTransactionIfNecessary(invocation.getMethod(), targetClass);
        Object retVal = null;
        try {
            retVal = invocation.proceed();
        }
        catch (Throwable ex) {
            this.doCloseTransactionAfterThrowing(txInfo, ex);
            throw ex;
        }
        finally {
            this.doFinally(txInfo);
        }
        this.doCommitTransactionAfterReturning(txInfo);
        return retVal;
    }
}

