/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.type;

import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.type.BaseTypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SqlTimeTypeHandler
extends BaseTypeHandler
implements TypeHandler {
    private static final String DATE_FORMAT = "hh:mm:ss";
    private static final DateFormat format = new SimpleDateFormat("hh:mm:ss");

    public void setParameter(PreparedStatement ps, int i, Object parameter, String jdbcType) throws SQLException {
        ps.setTime(i, (Time)parameter);
    }

    public Object getResult(ResultSet rs, String columnName) throws SQLException {
        Time sqlTime = rs.getTime(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return sqlTime;
    }

    public Object getResult(ResultSet rs, int columnIndex) throws SQLException {
        Time sqlTime = rs.getTime(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return sqlTime;
    }

    public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
        Time sqlTime = cs.getTime(columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return sqlTime;
    }

    public Object valueOf(String s) {
        try {
            Date date = format.parse(s);
            return new Time(date.getTime());
        }
        catch (ParseException e) {
            throw new SqlMapException("Error parsing default null value date.  Format must be 'hh:mm:ss'. Cause: " + e);
        }
    }
}

