/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.hivemind.lib.util.StrategyRegistry;
import org.apache.hivemind.lib.util.UtilMessages;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.util.Defense;

public class StrategyRegistryImpl
implements StrategyRegistry {
    private Map _registrations = new HashMap();
    private Map _cache = new WeakHashMap();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public synchronized void register(Class registrationClass, Object adaptor) {
        Defense.notNull((Object)registrationClass, (String)"registrationClass");
        Defense.notNull((Object)adaptor, (String)"adaptor");
        if (this._registrations.containsKey(registrationClass)) {
            throw new IllegalArgumentException(UtilMessages.duplicateRegistration(registrationClass));
        }
        this._registrations.put(registrationClass, adaptor);
        this._cache.clear();
    }

    public synchronized Object getStrategy(Class subjectClass) {
        Defense.notNull((Object)subjectClass, (String)"subjectClass");
        Object result = this._cache.get(subjectClass);
        if (result != null) {
            return result;
        }
        result = this.searchForAdaptor(subjectClass);
        this._cache.put(subjectClass, result);
        return result;
    }

    private Object searchForAdaptor(Class subjectClass) {
        int i;
        int length;
        Class<?>[] interfaces;
        LinkedList queue = null;
        Object result = null;
        Class searchClass = subjectClass;
        while (searchClass != (class$java$lang$Object == null ? StrategyRegistryImpl.class$("java.lang.Object") : class$java$lang$Object) && searchClass != null) {
            result = this._registrations.get(searchClass);
            if (result != null) {
                return result;
            }
            interfaces = searchClass.getInterfaces();
            length = interfaces.length;
            if (queue == null && length > 0) {
                queue = new LinkedList();
            }
            for (i = 0; i < length; ++i) {
                queue.addLast(interfaces[i]);
            }
            searchClass = this.getSuperclass(searchClass);
        }
        if (queue != null) {
            while (!queue.isEmpty()) {
                searchClass = (Class)queue.removeFirst();
                result = this._registrations.get(searchClass);
                if (result != null) {
                    return result;
                }
                interfaces = searchClass.getInterfaces();
                length = interfaces.length;
                for (i = 0; i < length; ++i) {
                    queue.addLast(interfaces[i]);
                }
            }
        }
        if ((result = this._registrations.get(class$java$lang$Object == null ? (class$java$lang$Object = StrategyRegistryImpl.class$("java.lang.Object")) : class$java$lang$Object)) != null) {
            return result;
        }
        throw new IllegalArgumentException(UtilMessages.strategyNotFound(subjectClass));
    }

    private Class getSuperclass(Class searchClass) {
        Class<?> componentType;
        if (searchClass.isArray() && !(componentType = searchClass.getComponentType()).isPrimitive() && componentType != (class$java$lang$Object == null ? (class$java$lang$Object = StrategyRegistryImpl.class$("java.lang.Object")) : class$java$lang$Object)) {
            return array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = StrategyRegistryImpl.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object;
        }
        return searchClass.getSuperclass();
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AdaptorRegistry[");
        Iterator i = this._registrations.entrySet().iterator();
        boolean showSep = false;
        while (i.hasNext()) {
            if (showSep) {
                buffer.append(' ');
            }
            Map.Entry entry = i.next();
            Class registeredClass = (Class)entry.getKey();
            buffer.append(ClassFabUtils.getJavaClassName((Class)registeredClass));
            buffer.append("=");
            buffer.append(entry.getValue());
            showSep = true;
        }
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

