/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.impl.BaseLocatable;
import org.apache.hivemind.lib.DefaultImplementationBuilder;
import org.apache.hivemind.lib.impl.ImplMessages;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.MethodIterator;
import org.apache.hivemind.service.MethodSignature;

public class DefaultImplementationBuilderImpl
extends BaseLocatable
implements DefaultImplementationBuilder {
    private Map _instances = Collections.synchronizedMap(new HashMap());
    private ClassFactory _classFactory;
    static /* synthetic */ Class class$java$lang$Object;

    public Object buildDefaultImplementation(Class interfaceType) {
        Object result = this._instances.get(interfaceType);
        if (result == null) {
            result = this.create(interfaceType);
            this._instances.put(interfaceType, result);
        }
        return result;
    }

    private Object create(Class interfaceType) {
        Class defaultClass = this.createClass(interfaceType);
        try {
            return defaultClass.newInstance();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ImplMessages.unableToCreateDefaultImplementation(interfaceType, ex), (Throwable)ex);
        }
    }

    private Class createClass(Class interfaceType) {
        if (!interfaceType.isInterface()) {
            throw new ApplicationRuntimeException(ImplMessages.notAnInterface(interfaceType));
        }
        String name = ClassFabUtils.generateClassName((Class)interfaceType);
        ClassFab cf = this._classFactory.newClass(name, class$java$lang$Object == null ? (class$java$lang$Object = DefaultImplementationBuilderImpl.class$("java.lang.Object")) : class$java$lang$Object);
        cf.addInterface(interfaceType);
        MethodIterator mi = new MethodIterator(interfaceType);
        while (mi.hasNext()) {
            ClassFabUtils.addNoOpMethod((ClassFab)cf, (MethodSignature)mi.next());
        }
        if (!mi.getToString()) {
            ClassFabUtils.addToStringMethod((ClassFab)cf, (String)ImplMessages.defaultImplementationDescription(interfaceType));
        }
        return cf.createClass();
    }

    public void setClassFactory(ClassFactory factory) {
        this._classFactory = factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

