/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.net.InetAddress;
import org.hsqldb.HsqlProperties;
import org.hsqldb.ServerConstants;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.StringUtil;

public final class ServerConfiguration
implements ServerConstants {
    private ServerConfiguration() {
    }

    public static int getDefaultPort(int n, boolean bl) {
        switch (n) {
            case 1: {
                return bl ? 554 : 9001;
            }
            case 0: {
                return bl ? 443 : 80;
            }
        }
        return -1;
    }

    public static HsqlProperties getPropertiesFromFile(String string) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        HsqlProperties hsqlProperties = new HsqlProperties(string);
        try {
            hsqlProperties.load();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hsqlProperties;
    }

    public static String[] listLocalInetAddressNames() {
        InetAddress[] inetAddressArray;
        InetAddress inetAddress;
        HashSet hashSet = new HashSet();
        try {
            int n;
            inetAddress = InetAddress.getLocalHost();
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostAddress());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n;
            inetAddress = InetAddress.getByName(null);
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostAddress());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            hashSet.add(InetAddress.getByName("loopback").getHostAddress());
            hashSet.add(InetAddress.getByName("loopback").getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String[])hashSet.toArray(new String[hashSet.size()]);
    }

    public static final HsqlProperties newDefaultProperties(int n) {
        HsqlProperties hsqlProperties = new HsqlProperties();
        hsqlProperties.setProperty("server.restart_on_shutdown", false);
        hsqlProperties.setProperty("server.address", "0.0.0.0");
        hsqlProperties.setProperty("server.database.0", "test");
        hsqlProperties.setProperty("server.dbname.0", "");
        hsqlProperties.setProperty("server.no_system_exit", true);
        boolean bl = false;
        try {
            bl = System.getProperty("javax.net.ssl.keyStore") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        hsqlProperties.setProperty("server.port", ServerConfiguration.getDefaultPort(n, bl));
        hsqlProperties.setProperty("server.silent", true);
        hsqlProperties.setProperty("server.tls", bl);
        hsqlProperties.setProperty("server.trace", false);
        hsqlProperties.setProperty("server.default_page", "index.html");
        hsqlProperties.setProperty("server.root", ".");
        return hsqlProperties;
    }

    public static void translateAddressProperty(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        String string = hsqlProperties.getProperty("server.address");
        if (StringUtil.isEmpty(string)) {
            hsqlProperties.setProperty("server.address", "0.0.0.0");
        }
    }

    public static void translateDefaultDatabaseProperty(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        String string = hsqlProperties.getProperty("server.database");
        if (string != null) {
            hsqlProperties.setProperty("server.database.0", string);
        }
    }

    public static void translateDefaultNoSystemExitProperty(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        hsqlProperties.setPropertyIfNotExists("server.no_system_exit", "false");
    }
}

