/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import java.util.HashMap;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.util.RegexpMatcher;
import org.apache.tapestry.valid.BaseValidator;
import org.apache.tapestry.valid.PatternDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class PatternValidator
extends BaseValidator {
    private String _patternString = "";
    private String _patternNotMatchedMessage;
    private PatternDelegate _patternDelegate;
    private String _scriptPath = "/org/apache/tapestry/valid/PatternValidator.script";

    public String getPatternNotMatchedMessage() {
        return this._patternNotMatchedMessage;
    }

    public String getPatternString() {
        return this._patternString;
    }

    public void setPatternNotMatchedMessage(String message) {
        this._patternNotMatchedMessage = message;
    }

    public void setPatternString(String pattern) {
        this._patternString = pattern;
    }

    public void setPatternDelegate(PatternDelegate patternDelegate) {
        this._patternDelegate = patternDelegate;
    }

    public PatternDelegate getPatternDelegate() {
        if (this._patternDelegate == null) {
            this._patternDelegate = new RegExpDelegate();
        }
        return this._patternDelegate;
    }

    public String toString(IFormComponent field, Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private String buildPatternNotMatchedMessage(IFormComponent field, String patternString) {
        String templateMessage = this.getPattern(this._patternNotMatchedMessage, "pattern-not-matched", field.getPage().getLocale());
        return this.formatString(templateMessage, field.getDisplayName(), patternString);
    }

    public Object toObject(IFormComponent field, String input) throws ValidatorException {
        if (this.checkRequired(field, input)) {
            return null;
        }
        boolean matched = false;
        try {
            matched = this.getPatternDelegate().contains(this._patternString, input);
        }
        catch (Throwable t) {
            throw new ApplicationRuntimeException(Tapestry.format("PatternValidator.pattern-match-error", this._patternString, field.getDisplayName()), (Object)field, field.getLocation(), t);
        }
        if (!matched) {
            throw new ValidatorException(this.buildPatternNotMatchedMessage(field, this._patternString), ValidationConstraint.PATTERN_MISMATCH);
        }
        return input;
    }

    public void setScriptPath(String scriptPath) {
        this._scriptPath = scriptPath;
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer, IRequestCycle cycle) {
        if (!this.isClientScriptingEnabled()) {
            return;
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        if (this.isRequired()) {
            symbols.put("requiredMessage", this.buildRequiredMessage(field));
        }
        symbols.put("patternNotMatchedMessage", this.buildPatternNotMatchedMessage(field, this.getEscapedPatternString()));
        this.processValidatorScript(this._scriptPath, cycle, field, symbols);
    }

    public String getEscapedPatternString() {
        return this.getPatternDelegate().getEscapedPatternString(this._patternString);
    }

    public String toString() {
        return "Pattern: " + this._patternString + "; Script Path: " + this._scriptPath + "; Pattern Delegate: " + this._patternDelegate;
    }

    private static class RegExpDelegate
    implements PatternDelegate {
        private RegexpMatcher _matcher;

        private RegExpDelegate() {
        }

        private RegexpMatcher getPatternMatcher() {
            if (this._matcher == null) {
                this._matcher = new RegexpMatcher();
            }
            return this._matcher;
        }

        public boolean contains(String patternString, String input) {
            return this.getPatternMatcher().contains(patternString, input);
        }

        public String getEscapedPatternString(String patternString) {
            return this.getPatternMatcher().getEscapedPatternString(patternString);
        }
    }
}

