/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.lib.util.StrategyRegistry;
import org.apache.hivemind.lib.util.StrategyRegistryImpl;
import org.apache.hivemind.util.PropertyUtils;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.AbstractNumericValidator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public class NumberValidator
extends AbstractNumericValidator {
    private static final Map TYPES = new HashMap();
    private Class _valueTypeClass = Integer.TYPE;
    private Number _minimum;
    private Number _maximum;
    private static StrategyRegistry _numberAdaptors;
    public static final int NUMBER_TYPE_INTEGER = 0;
    public static final int NUMBER_TYPE_REAL = 1;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public NumberValidator() {
    }

    public NumberValidator(String initializer) {
        PropertyUtils.configureProperties((Object)this, (String)initializer);
    }

    public String toString(IFormComponent field, Object value) {
        Number number;
        if (value == null) {
            return null;
        }
        if (this.getZeroIsNull() && (number = (Number)value).doubleValue() == 0.0) {
            return null;
        }
        return value.toString();
    }

    private NumberStrategy getStrategy(IFormComponent field) {
        NumberStrategy result = NumberValidator.getStrategy(this._valueTypeClass);
        if (result == null) {
            throw new ApplicationRuntimeException(Tapestry.format("NumberValidator.no-adaptor-for-field", field, this._valueTypeClass.getName()));
        }
        return result;
    }

    public static NumberStrategy getStrategy(Class type) {
        return (NumberStrategy)_numberAdaptors.getStrategy(type);
    }

    public Object toObject(IFormComponent field, String value) throws ValidatorException {
        if (this.checkRequired(field, value)) {
            return null;
        }
        NumberStrategy adaptor = this.getStrategy(field);
        Number result = null;
        try {
            result = adaptor.parse(value);
        }
        catch (NumberFormatException ex) {
            throw new ValidatorException(this.buildInvalidNumericFormatMessage(field), ValidationConstraint.NUMBER_FORMAT);
        }
        if (this._minimum != null && adaptor.compare(result, this._minimum) < 0) {
            throw new ValidatorException(this.buildNumberTooSmallMessage(field, this._minimum), ValidationConstraint.TOO_SMALL);
        }
        if (this._maximum != null && adaptor.compare(result, this._maximum) > 0) {
            throw new ValidatorException(this.buildNumberTooLargeMessage(field, this._maximum), ValidationConstraint.TOO_LARGE);
        }
        return result;
    }

    public Number getMaximum() {
        return this._maximum;
    }

    public boolean getHasMaximum() {
        return this._maximum != null;
    }

    public void setMaximum(Number maximum) {
        this._maximum = maximum;
    }

    public Number getMinimum() {
        return this._minimum;
    }

    public boolean getHasMinimum() {
        return this._minimum != null;
    }

    public void setMinimum(Number minimum) {
        this._minimum = minimum;
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer, IRequestCycle cycle) {
        if (!this.isClientScriptingEnabled()) {
            return;
        }
        if (!this.isRequired() && this._minimum == null && this._maximum == null) {
            return;
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        if (this.isRequired()) {
            symbols.put("requiredMessage", this.buildRequiredMessage(field));
        }
        if (this.isIntegerNumber()) {
            symbols.put("formatMessage", this.buildInvalidIntegerFormatMessage(field));
        } else {
            symbols.put("formatMessage", this.buildInvalidNumericFormatMessage(field));
        }
        if (this._minimum != null || this._maximum != null) {
            symbols.put("rangeMessage", this.buildRangeMessage(field, this._minimum, this._maximum));
        }
        this.processValidatorScript(this.getScriptPath(), cycle, field, symbols);
    }

    public void setValueType(String typeName) {
        Class typeClass = (Class)TYPES.get(typeName);
        if (typeClass == null) {
            throw new ApplicationRuntimeException(Tapestry.format("NumberValidator.unknown-type", typeName));
        }
        this._valueTypeClass = typeClass;
    }

    public void setValueTypeClass(Class valueTypeClass) {
        this._valueTypeClass = valueTypeClass;
    }

    public Class getValueTypeClass() {
        return this._valueTypeClass;
    }

    public boolean isIntegerNumber() {
        NumberStrategy strategy = (NumberStrategy)_numberAdaptors.getStrategy(this._valueTypeClass);
        if (strategy == null) {
            return false;
        }
        return strategy.getNumberType() == 0;
    }

    protected String getDefaultScriptPath() {
        return "/org/apache/tapestry/valid/NumberValidator.script";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TYPES.put("boolean", Boolean.TYPE);
        TYPES.put("Boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = NumberValidator.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        TYPES.put("java.lang.Boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = NumberValidator.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        TYPES.put("char", Character.TYPE);
        TYPES.put("Character", class$java$lang$Character == null ? (class$java$lang$Character = NumberValidator.class$("java.lang.Character")) : class$java$lang$Character);
        TYPES.put("java.lang.Character", class$java$lang$Character == null ? (class$java$lang$Character = NumberValidator.class$("java.lang.Character")) : class$java$lang$Character);
        TYPES.put("short", Short.TYPE);
        TYPES.put("Short", class$java$lang$Short == null ? (class$java$lang$Short = NumberValidator.class$("java.lang.Short")) : class$java$lang$Short);
        TYPES.put("java.lang.Short", class$java$lang$Short == null ? (class$java$lang$Short = NumberValidator.class$("java.lang.Short")) : class$java$lang$Short);
        TYPES.put("int", Integer.TYPE);
        TYPES.put("Integer", class$java$lang$Integer == null ? (class$java$lang$Integer = NumberValidator.class$("java.lang.Integer")) : class$java$lang$Integer);
        TYPES.put("java.lang.Integer", class$java$lang$Integer == null ? (class$java$lang$Integer = NumberValidator.class$("java.lang.Integer")) : class$java$lang$Integer);
        TYPES.put("long", Long.TYPE);
        TYPES.put("Long", class$java$lang$Long == null ? (class$java$lang$Long = NumberValidator.class$("java.lang.Long")) : class$java$lang$Long);
        TYPES.put("java.lang.Long", class$java$lang$Long == null ? (class$java$lang$Long = NumberValidator.class$("java.lang.Long")) : class$java$lang$Long);
        TYPES.put("float", Float.TYPE);
        TYPES.put("Float", class$java$lang$Float == null ? (class$java$lang$Float = NumberValidator.class$("java.lang.Float")) : class$java$lang$Float);
        TYPES.put("java.lang.Float", class$java$lang$Float == null ? (class$java$lang$Float = NumberValidator.class$("java.lang.Float")) : class$java$lang$Float);
        TYPES.put("byte", Byte.TYPE);
        TYPES.put("Byte", class$java$lang$Byte == null ? (class$java$lang$Byte = NumberValidator.class$("java.lang.Byte")) : class$java$lang$Byte);
        TYPES.put("java.lang.Byte", class$java$lang$Byte == null ? (class$java$lang$Byte = NumberValidator.class$("java.lang.Byte")) : class$java$lang$Byte);
        TYPES.put("double", Double.TYPE);
        TYPES.put("Double", class$java$lang$Double == null ? (class$java$lang$Double = NumberValidator.class$("java.lang.Double")) : class$java$lang$Double);
        TYPES.put("java.lang.Double", class$java$lang$Double == null ? (class$java$lang$Double = NumberValidator.class$("java.lang.Double")) : class$java$lang$Double);
        TYPES.put("java.math.BigInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberValidator.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        TYPES.put("java.math.BigDecimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberValidator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        _numberAdaptors = new StrategyRegistryImpl();
        ByteAdaptor byteAdaptor = new ByteAdaptor();
        ShortAdaptor shortAdaptor = new ShortAdaptor();
        IntAdaptor intAdaptor = new IntAdaptor();
        LongAdaptor longAdaptor = new LongAdaptor();
        FloatAdaptor floatAdaptor = new FloatAdaptor();
        DoubleAdaptor doubleAdaptor = new DoubleAdaptor();
        _numberAdaptors.register(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberValidator.class$("java.lang.Byte")) : class$java$lang$Byte, (Object)byteAdaptor);
        _numberAdaptors.register(Byte.TYPE, (Object)byteAdaptor);
        _numberAdaptors.register(class$java$lang$Short == null ? (class$java$lang$Short = NumberValidator.class$("java.lang.Short")) : class$java$lang$Short, (Object)shortAdaptor);
        _numberAdaptors.register(Short.TYPE, (Object)shortAdaptor);
        _numberAdaptors.register(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberValidator.class$("java.lang.Integer")) : class$java$lang$Integer, (Object)intAdaptor);
        _numberAdaptors.register(Integer.TYPE, (Object)intAdaptor);
        _numberAdaptors.register(class$java$lang$Long == null ? (class$java$lang$Long = NumberValidator.class$("java.lang.Long")) : class$java$lang$Long, (Object)longAdaptor);
        _numberAdaptors.register(Long.TYPE, (Object)longAdaptor);
        _numberAdaptors.register(class$java$lang$Float == null ? (class$java$lang$Float = NumberValidator.class$("java.lang.Float")) : class$java$lang$Float, (Object)floatAdaptor);
        _numberAdaptors.register(Float.TYPE, (Object)floatAdaptor);
        _numberAdaptors.register(class$java$lang$Double == null ? (class$java$lang$Double = NumberValidator.class$("java.lang.Double")) : class$java$lang$Double, (Object)doubleAdaptor);
        _numberAdaptors.register(Double.TYPE, (Object)doubleAdaptor);
        _numberAdaptors.register(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberValidator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, (Object)new BigDecimalAdaptor());
        _numberAdaptors.register(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberValidator.class$("java.math.BigInteger")) : class$java$math$BigInteger, (Object)new BigIntegerAdaptor());
    }

    private static class BigIntegerAdaptor
    extends IntegerNumberAdaptor {
        private BigIntegerAdaptor() {
        }

        public Number parse(String value) {
            return new BigInteger(value);
        }

        protected Number coerce(Number number) {
            return new BigInteger(number.toString());
        }
    }

    private static class BigDecimalAdaptor
    extends RealNumberAdaptor {
        private BigDecimalAdaptor() {
        }

        public Number parse(String value) {
            return new BigDecimal(value);
        }

        protected Number coerce(Number number) {
            return new BigDecimal(number.doubleValue());
        }
    }

    private static class DoubleAdaptor
    extends RealNumberAdaptor {
        private DoubleAdaptor() {
        }

        public Number parse(String value) {
            return new Double(value);
        }

        protected Number coerce(Number number) {
            return new Double(number.doubleValue());
        }
    }

    private static class FloatAdaptor
    extends RealNumberAdaptor {
        private FloatAdaptor() {
        }

        public Number parse(String value) {
            return new Float(value);
        }

        protected Number coerce(Number number) {
            return new Float(number.floatValue());
        }
    }

    private static class LongAdaptor
    extends IntegerNumberAdaptor {
        private LongAdaptor() {
        }

        public Number parse(String value) {
            return new Long(value);
        }

        protected Number coerce(Number number) {
            return new Long(number.longValue());
        }
    }

    private static class IntAdaptor
    extends IntegerNumberAdaptor {
        private IntAdaptor() {
        }

        public Number parse(String value) {
            return new Integer(value);
        }

        protected Number coerce(Number number) {
            return new Integer(number.intValue());
        }
    }

    private static class ShortAdaptor
    extends IntegerNumberAdaptor {
        private ShortAdaptor() {
        }

        public Number parse(String value) {
            return new Short(value);
        }

        protected Number coerce(Number number) {
            return new Short(number.shortValue());
        }
    }

    private static class ByteAdaptor
    extends IntegerNumberAdaptor {
        private ByteAdaptor() {
        }

        public Number parse(String value) {
            return new Byte(value);
        }

        protected Number coerce(Number number) {
            return new Byte(number.byteValue());
        }
    }

    private static abstract class RealNumberAdaptor
    extends NumberStrategy {
        private RealNumberAdaptor() {
        }

        public int getNumberType() {
            return 1;
        }
    }

    private static abstract class IntegerNumberAdaptor
    extends NumberStrategy {
        private IntegerNumberAdaptor() {
        }

        public int getNumberType() {
            return 0;
        }
    }

    public static abstract class NumberStrategy {
        public abstract Number parse(String var1);

        public abstract int getNumberType();

        public int compare(Number left, Number right) {
            if (!left.getClass().equals(right.getClass())) {
                right = this.coerce(right);
            }
            Comparable lc = (Comparable)((Object)left);
            return lc.compareTo(right);
        }

        protected abstract Number coerce(Number var1);
    }
}

