/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.spec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ToStringBuilder;
import org.apache.tapestry.spec.IAssetSpecification;
import org.apache.tapestry.spec.IBeanSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;
import org.apache.tapestry.spec.IParameterSpecification;
import org.apache.tapestry.spec.IPropertySpecification;
import org.apache.tapestry.spec.InjectSpecification;
import org.apache.tapestry.spec.LocatablePropertyHolder;
import org.apache.tapestry.spec.SpecMessages;

public class ComponentSpecification
extends LocatablePropertyHolder
implements IComponentSpecification {
    private String _componentClassName;
    private String _description;
    protected Map _components;
    protected Map _assets;
    protected Map _parameters;
    protected Map _beans;
    protected Set _reservedParameterNames;
    private boolean _allowBody = true;
    private boolean _allowInformalParameters = true;
    private String _publicId;
    private boolean _pageSpecification;
    private Resource _specificationLocation;
    private Map _propertySpecifications;
    private List _injectSpecifications;
    private Map _claimedProperties;
    private boolean _deprecated = false;

    public void addAsset(String name, IAssetSpecification asset) {
        IAssetSpecification existing;
        if (this._assets == null) {
            this._assets = new HashMap();
        }
        if ((existing = (IAssetSpecification)this._assets.get(name)) != null) {
            throw new ApplicationRuntimeException(SpecMessages.duplicateAsset(name, existing), asset.getLocation(), null);
        }
        this.claimProperty(asset.getPropertyName(), asset);
        this._assets.put(name, asset);
    }

    public void addComponent(String id, IContainedComponent component) {
        IContainedComponent existing;
        if (this._components == null) {
            this._components = new HashMap();
        }
        if ((existing = (IContainedComponent)this._components.get(id)) != null) {
            throw new ApplicationRuntimeException(SpecMessages.duplicateComponent(id, existing), component.getLocation(), null);
        }
        this._components.put(id, component);
        this.claimProperty(component.getPropertyName(), component);
    }

    public void addParameter(IParameterSpecification spec) {
        if (this._parameters == null) {
            this._parameters = new HashMap();
        }
        String name = spec.getParameterName();
        this.addParameterByName(name, spec);
        Iterator i = spec.getAliasNames().iterator();
        while (i.hasNext()) {
            String alias = (String)i.next();
            this.addParameterByName(alias, spec);
        }
        this.claimProperty(spec.getPropertyName(), spec);
    }

    private void addParameterByName(String name, IParameterSpecification spec) {
        IParameterSpecification existing = (IParameterSpecification)this._parameters.get(name);
        if (existing != null) {
            throw new ApplicationRuntimeException(SpecMessages.duplicateParameter(name, existing), spec.getLocation(), null);
        }
        this._parameters.put(name, spec);
        this.addReservedParameterName(name);
    }

    public boolean getAllowBody() {
        return this._allowBody;
    }

    public boolean getAllowInformalParameters() {
        return this._allowInformalParameters;
    }

    public IAssetSpecification getAsset(String name) {
        return (IAssetSpecification)this.get(this._assets, name);
    }

    public List getAssetNames() {
        return this.sortedKeys(this._assets);
    }

    public IContainedComponent getComponent(String id) {
        return (IContainedComponent)this.get(this._components, id);
    }

    public String getComponentClassName() {
        return this._componentClassName;
    }

    public List getComponentIds() {
        return this.sortedKeys(this._components);
    }

    public IParameterSpecification getParameter(String name) {
        return (IParameterSpecification)this.get(this._parameters, name);
    }

    public Collection getRequiredParameters() {
        if (this._parameters == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IParameterSpecification> result = new ArrayList<IParameterSpecification>();
        Iterator i = this._parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            IParameterSpecification spec = (IParameterSpecification)entry.getValue();
            if (!spec.isRequired() || !name.equals(spec.getParameterName())) continue;
            result.add(spec);
        }
        return result;
    }

    public List getParameterNames() {
        return this.sortedKeys(this._parameters);
    }

    public void setAllowBody(boolean value) {
        this._allowBody = value;
    }

    public void setAllowInformalParameters(boolean value) {
        this._allowInformalParameters = value;
    }

    public void setComponentClassName(String value) {
        this._componentClassName = value;
    }

    public void addBeanSpecification(String name, IBeanSpecification specification) {
        IBeanSpecification existing;
        if (this._beans == null) {
            this._beans = new HashMap();
        }
        if ((existing = (IBeanSpecification)this._beans.get(name)) != null) {
            throw new ApplicationRuntimeException(SpecMessages.duplicateBean(name, existing), specification.getLocation(), null);
        }
        this.claimProperty(specification.getPropertyName(), specification);
        this._beans.put(name, specification);
    }

    public IBeanSpecification getBeanSpecification(String name) {
        return (IBeanSpecification)this.get(this._beans, name);
    }

    public Collection getBeanNames() {
        if (this._beans == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this._beans.keySet());
    }

    public void addReservedParameterName(String value) {
        if (this._reservedParameterNames == null) {
            this._reservedParameterNames = new HashSet();
        }
        this._reservedParameterNames.add(value.toLowerCase());
    }

    public boolean isReservedParameterName(String value) {
        if (this._reservedParameterNames == null) {
            return false;
        }
        return this._reservedParameterNames.contains(value.toLowerCase());
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("componentClassName", this._componentClassName);
        builder.append("pageSpecification", this._pageSpecification);
        builder.append("specificationLocation", (Object)this._specificationLocation);
        builder.append("allowBody", this._allowBody);
        builder.append("allowInformalParameter", this._allowInformalParameters);
        return builder.toString();
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getPublicId() {
        return this._publicId;
    }

    public void setPublicId(String publicId) {
        this._publicId = publicId;
    }

    public boolean isPageSpecification() {
        return this._pageSpecification;
    }

    public void setPageSpecification(boolean pageSpecification) {
        this._pageSpecification = pageSpecification;
    }

    private List sortedKeys(Map input) {
        if (input == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList(input.keySet());
        Collections.sort(result);
        return result;
    }

    private Object get(Map map, Object key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public Resource getSpecificationLocation() {
        return this._specificationLocation;
    }

    public void setSpecificationLocation(Resource specificationLocation) {
        this._specificationLocation = specificationLocation;
    }

    public void addPropertySpecification(IPropertySpecification spec) {
        String name;
        IPropertySpecification existing;
        if (this._propertySpecifications == null) {
            this._propertySpecifications = new HashMap();
        }
        if ((existing = (IPropertySpecification)this._propertySpecifications.get(name = spec.getName())) != null) {
            throw new ApplicationRuntimeException(SpecMessages.duplicateProperty(name, existing), spec.getLocation(), null);
        }
        this.claimProperty(name, spec);
        this._propertySpecifications.put(name, spec);
    }

    public List getPropertySpecificationNames() {
        return this.sortedKeys(this._propertySpecifications);
    }

    public IPropertySpecification getPropertySpecification(String name) {
        return (IPropertySpecification)this.get(this._propertySpecifications, name);
    }

    public void addInjectSpecification(InjectSpecification spec) {
        if (this._injectSpecifications == null) {
            this._injectSpecifications = new ArrayList();
        }
        this.claimProperty(spec.getProperty(), spec);
        this._injectSpecifications.add(spec);
    }

    public List getInjectSpecifications() {
        return this.safeList(this._injectSpecifications);
    }

    private List safeList(List input) {
        if (input == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(input);
    }

    private void claimProperty(String propertyName, Object subSpecification) {
        Object existing;
        if (propertyName == null) {
            return;
        }
        if (this._claimedProperties == null) {
            this._claimedProperties = new HashMap();
        }
        if ((existing = this._claimedProperties.get(propertyName)) != null) {
            throw new ApplicationRuntimeException(SpecMessages.claimedProperty(propertyName, existing), HiveMind.getLocation((Object)subSpecification), null);
        }
        this._claimedProperties.put(propertyName, subSpecification);
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this._deprecated = deprecated;
    }

    public Set getReservedParameterNames() {
        if (this._reservedParameterNames == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(this._reservedParameterNames);
    }
}

