/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.Iterator;
import java.util.Map;
import org.apache.hivemind.util.ToStringBuilder;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.parse.LocalizationToken;

public class LocalizedStringRender
implements IRender {
    private IComponent _component;
    private String _key;
    private Map _attributes;
    private String _value;
    private boolean _raw;

    public LocalizedStringRender(IComponent component, LocalizationToken token) {
        this._component = component;
        this._key = token.getKey();
        this._raw = token.isRaw();
        this._attributes = token.getAttributes();
    }

    public void render(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding()) {
            return;
        }
        if (this._attributes != null) {
            writer.begin("span");
            Iterator i = this._attributes.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String attributeName = (String)entry.getKey();
                String attributeValue = (String)entry.getValue();
                writer.attribute(attributeName, attributeValue);
            }
        }
        if (this._value == null) {
            this._value = this._component.getMessages().getMessage(this._key);
        }
        writer.print(this._value, this._raw);
        if (this._attributes != null) {
            writer.end();
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("component", (Object)this._component);
        builder.append("key", this._key);
        builder.append("raw", this._raw);
        builder.append("attributes", (Object)this._attributes);
        return builder.toString();
    }
}

