/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.hivemind.Resource;
import org.apache.hivemind.lib.chain.ChainBuilder;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.engine.IPropertySource;
import org.apache.tapestry.event.ResetEventListener;
import org.apache.tapestry.services.ComponentPropertySource;
import org.apache.tapestry.services.impl.ImplMessages;
import org.apache.tapestry.services.impl.LocalizedPropertySource;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.util.PropertyHolderPropertySource;

public class ComponentPropertySourceImpl
implements ComponentPropertySource,
ResetEventListener {
    private IPropertySource _globalProperties;
    private ChainBuilder _chainBuilder;
    private Map _componentSources = new HashMap();
    private Map _localizedComponentSources = new HashMap();
    private Map _namespaceSources = new HashMap();
    private Map _localizedNamespaceSources = new HashMap();
    static /* synthetic */ Class class$org$apache$tapestry$engine$IPropertySource;

    public synchronized void resetEventDidOccur() {
        this._componentSources.clear();
        this._localizedComponentSources.clear();
        this._namespaceSources.clear();
        this._localizedNamespaceSources.clear();
    }

    private synchronized IPropertySource getSourceForNamespace(INamespace namespace) {
        Resource key = namespace.getSpecificationLocation();
        IPropertySource result = (IPropertySource)this._namespaceSources.get(key);
        if (result == null) {
            result = this.createSourceForNamespace(namespace);
            this._namespaceSources.put(key, result);
        }
        return result;
    }

    private synchronized IPropertySource getSourceForComponent(IComponent component) {
        Resource key = component.getSpecification().getSpecificationLocation();
        IPropertySource result = (IPropertySource)this._componentSources.get(key);
        if (result == null) {
            result = this.createSourceForComponent(component);
            this._componentSources.put(key, result);
        }
        return result;
    }

    private synchronized LocalizedPropertySource getLocalizedSourceForComponent(IComponent component) {
        Resource key = component.getSpecification().getSpecificationLocation();
        LocalizedPropertySource result = (LocalizedPropertySource)this._localizedComponentSources.get(key);
        if (result == null) {
            result = new LocalizedPropertySource(this.getSourceForComponent(component));
            this._localizedComponentSources.put(key, result);
        }
        return result;
    }

    private synchronized LocalizedPropertySource getLocalizedSourceForNamespace(INamespace namespace) {
        Resource key = namespace.getSpecificationLocation();
        LocalizedPropertySource result = (LocalizedPropertySource)this._localizedNamespaceSources.get(key);
        if (result == null) {
            result = new LocalizedPropertySource(this.getSourceForNamespace(namespace));
            this._localizedNamespaceSources.put(key, result);
        }
        return result;
    }

    private IPropertySource createSourceForComponent(IComponent component) {
        IComponentSpecification specification = component.getSpecification();
        ArrayList<IPropertySource> sources = new ArrayList<IPropertySource>();
        sources.add(new PropertyHolderPropertySource(specification));
        sources.add(this.getSourceForNamespace(component.getNamespace()));
        return (IPropertySource)this._chainBuilder.buildImplementation(class$org$apache$tapestry$engine$IPropertySource == null ? (class$org$apache$tapestry$engine$IPropertySource = ComponentPropertySourceImpl.class$("org.apache.tapestry.engine.IPropertySource")) : class$org$apache$tapestry$engine$IPropertySource, sources, ImplMessages.componentPropertySourceDescription(specification));
    }

    private IPropertySource createSourceForNamespace(INamespace namespace) {
        ArrayList<IPropertySource> sources = new ArrayList<IPropertySource>();
        sources.add(new PropertyHolderPropertySource(namespace.getSpecification()));
        sources.add(this._globalProperties);
        return (IPropertySource)this._chainBuilder.buildImplementation(class$org$apache$tapestry$engine$IPropertySource == null ? (class$org$apache$tapestry$engine$IPropertySource = ComponentPropertySourceImpl.class$("org.apache.tapestry.engine.IPropertySource")) : class$org$apache$tapestry$engine$IPropertySource, sources, ImplMessages.namespacePropertySourceDescription(namespace));
    }

    public String getComponentProperty(IComponent component, String propertyName) {
        return this.getSourceForComponent(component).getPropertyValue(propertyName);
    }

    public String getLocalizedComponentProperty(IComponent component, Locale locale, String propertyName) {
        return this.getLocalizedSourceForComponent(component).getPropertyValue(propertyName, locale);
    }

    public String getNamespaceProperty(INamespace namespace, String propertyName) {
        return this.getSourceForNamespace(namespace).getPropertyValue(propertyName);
    }

    public String getLocalizedNamespaceProperty(INamespace namespace, Locale locale, String propertyName) {
        return this.getLocalizedSourceForNamespace(namespace).getPropertyValue(propertyName, locale);
    }

    public void setChainBuilder(ChainBuilder chainBuilder) {
        this._chainBuilder = chainBuilder;
    }

    public void setGlobalProperties(IPropertySource globalProperties) {
        this._globalProperties = globalProperties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

