/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.resolver;

import org.apache.commons.logging.Log;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.LocationImpl;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageNotFoundException;
import org.apache.tapestry.resolver.AbstractSpecificationResolver;
import org.apache.tapestry.resolver.PageSpecificationResolver;
import org.apache.tapestry.resolver.ResolverMessages;
import org.apache.tapestry.services.ComponentPropertySource;
import org.apache.tapestry.spec.ComponentSpecification;
import org.apache.tapestry.spec.IComponentSpecification;

public class PageSpecificationResolverImpl
extends AbstractSpecificationResolver
implements PageSpecificationResolver {
    private static final String WEB_INF = "/WEB-INF/";
    private Log _log;
    private String _simpleName;
    private INamespace _applicationNamespace;
    private INamespace _frameworkNamespace;
    private ComponentPropertySource _componentPropertySource;

    public void initializeService() {
        this._applicationNamespace = this.getSpecificationSource().getApplicationNamespace();
        this._frameworkNamespace = this.getSpecificationSource().getFrameworkNamespace();
        super.initializeService();
    }

    protected void reset() {
        this._simpleName = null;
        super.reset();
    }

    public void resolve(IRequestCycle cycle, String prefixedName) {
        this.reset();
        INamespace namespace = null;
        int colonx = prefixedName.indexOf(58);
        if (colonx > 0) {
            this._simpleName = prefixedName.substring(colonx + 1);
            String namespaceId = prefixedName.substring(0, colonx);
            namespace = this.findNamespaceForId(this._applicationNamespace, namespaceId);
        } else {
            this._simpleName = prefixedName;
            namespace = this._applicationNamespace;
        }
        this.setNamespace(namespace);
        if (namespace.containsPage(this._simpleName)) {
            this.setSpecification(namespace.getPageSpecification(this._simpleName));
            return;
        }
        this.searchForPage(cycle);
        if (this.getSpecification() == null) {
            throw new PageNotFoundException(ResolverMessages.noSuchPage(this._simpleName, namespace));
        }
    }

    public String getSimplePageName() {
        return this._simpleName;
    }

    private void searchForPage(IRequestCycle cycle) {
        IComponentSpecification specification;
        INamespace namespace = this.getNamespace();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)ResolverMessages.resolvingPage(this._simpleName, namespace));
        }
        if (this._simpleName.regionMatches(true, 0, WEB_INF, 0, WEB_INF.length()) || this._simpleName.regionMatches(true, 0, WEB_INF, 1, WEB_INF.length() - 1)) {
            throw new ApplicationRuntimeException(ResolverMessages.webInfNotAllowed(this._simpleName));
        }
        String expectedName = this._simpleName + ".page";
        Resource namespaceLocation = namespace.getSpecificationLocation();
        if (this.found(namespaceLocation, expectedName)) {
            return;
        }
        if (namespace.isApplicationNamespace()) {
            if (this.found(this.getWebInfAppLocation(), expectedName)) {
                return;
            }
            if (this.found(this.getWebInfLocation(), expectedName)) {
                return;
            }
            if (this.found(this.getContextRoot(), expectedName)) {
                return;
            }
            String templateName = this._simpleName + "." + this.getTemplateExtension();
            Resource templateResource = this.getContextRoot().getRelativeResource(templateName);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)ResolverMessages.checkingResource(templateResource));
            }
            if (templateResource.getResourceURL() != null) {
                this.setupImplicitPage(templateResource, namespaceLocation);
                return;
            }
            if (this._frameworkNamespace.containsPage(this._simpleName)) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)ResolverMessages.foundFrameworkPage(this._simpleName));
                }
                this.setNamespace(this._frameworkNamespace);
                this.setSpecification(this._frameworkNamespace.getPageSpecification(this._simpleName));
                return;
            }
        }
        if ((specification = this.getDelegate().findPageSpecification(cycle, namespace, this._simpleName)) != null) {
            this.setSpecification(specification);
            this.install();
        }
    }

    private void setupImplicitPage(Resource resource, Resource namespaceLocation) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)ResolverMessages.foundHTMLTemplate(resource));
        }
        Resource pageResource = namespaceLocation.getRelativeResource(this._simpleName + ".page");
        ComponentSpecification specification = new ComponentSpecification();
        specification.setPageSpecification(true);
        specification.setSpecificationLocation(pageResource);
        specification.setLocation((Location)new LocationImpl(resource));
        this.setSpecification(specification);
        this.install();
    }

    private boolean found(Resource baseResource, String expectedName) {
        Resource resource = baseResource.getRelativeResource(expectedName);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)ResolverMessages.checkingResource(resource));
        }
        if (resource.getResourceURL() == null) {
            return false;
        }
        this.setSpecification(this.getSpecificationSource().getPageSpecification(resource));
        this.install();
        return true;
    }

    private void install() {
        INamespace namespace = this.getNamespace();
        IComponentSpecification specification = this.getSpecification();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)ResolverMessages.installingPage(this._simpleName, namespace, specification));
        }
        namespace.installPageSpecification(this._simpleName, specification);
    }

    private String getTemplateExtension() {
        return this._componentPropertySource.getNamespaceProperty(this.getNamespace(), "org.apache.tapestry.template-extension");
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public void setComponentPropertySource(ComponentPropertySource componentPropertySource) {
        this._componentPropertySource = componentPropertySource;
    }
}

