/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.record;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.record.PersistentPropertyDataEncoder;
import org.apache.tapestry.record.PropertyChange;
import org.apache.tapestry.record.PropertyChangeImpl;
import org.apache.tapestry.record.RecordMessages;
import org.apache.tapestry.util.io.ResolvingObjectInputStream;
import org.apache.tapestry.util.io.TeeOutputStream;

public class PersistentPropertyDataEncoderImpl
implements PersistentPropertyDataEncoder {
    private ClassResolver _classResolver;
    public static final String BYTESTREAM_PREFIX = "B";
    public static final String GZIP_BYTESTREAM_PREFIX = "Z";

    public String encodePageChanges(List changes) {
        Defense.notNull((Object)changes, (String)"changes");
        if (changes.isEmpty()) {
            return "";
        }
        try {
            ByteArrayOutputStream bosPlain = new ByteArrayOutputStream();
            ByteArrayOutputStream bosCompressed = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(bosCompressed);
            TeeOutputStream tos = new TeeOutputStream(bosPlain, gos);
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(tos));
            this.writeChangesToStream(changes, oos);
            oos.close();
            boolean useCompressed = bosCompressed.size() < bosPlain.size();
            byte[] data = useCompressed ? bosCompressed.toByteArray() : bosPlain.toByteArray();
            byte[] encoded = Base64.encodeBase64((byte[])data);
            String prefix = useCompressed ? GZIP_BYTESTREAM_PREFIX : BYTESTREAM_PREFIX;
            return prefix + new String(encoded);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(RecordMessages.encodeFailure(ex), (Throwable)ex);
        }
    }

    public List decodePageChanges(String encoded) {
        if (HiveMind.isBlank((String)encoded)) {
            return Collections.EMPTY_LIST;
        }
        String prefix = encoded.substring(0, 1);
        if (!prefix.equals(BYTESTREAM_PREFIX) && !prefix.equals(GZIP_BYTESTREAM_PREFIX)) {
            throw new ApplicationRuntimeException(RecordMessages.unknownPrefix(prefix));
        }
        try {
            byte[] decoded = Base64.decodeBase64((byte[])encoded.substring(1).getBytes());
            InputStream is = new ByteArrayInputStream(decoded);
            if (prefix.equals(GZIP_BYTESTREAM_PREFIX)) {
                is = new GZIPInputStream(is);
            }
            ResolvingObjectInputStream ois = new ResolvingObjectInputStream(this._classResolver, new BufferedInputStream(is));
            List result = this.readChangesFromStream(ois);
            ois.close();
            return result;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(RecordMessages.decodeFailure(ex), (Throwable)ex);
        }
    }

    private void writeChangesToStream(List changes, ObjectOutputStream oos) throws IOException {
        oos.writeInt(changes.size());
        Iterator i = changes.iterator();
        while (i.hasNext()) {
            PropertyChange pc = (PropertyChange)i.next();
            String componentPath = pc.getComponentPath();
            String propertyName = pc.getPropertyName();
            Object value = pc.getNewValue();
            oos.writeBoolean(componentPath != null);
            if (componentPath != null) {
                oos.writeUTF(componentPath);
            }
            oos.writeUTF(propertyName);
            oos.writeObject(value);
        }
    }

    private List readChangesFromStream(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ArrayList<PropertyChangeImpl> result = new ArrayList<PropertyChangeImpl>();
        int count = ois.readInt();
        for (int i = 0; i < count; ++i) {
            boolean hasPath = ois.readBoolean();
            String componentPath = hasPath ? ois.readUTF() : null;
            String propertyName = ois.readUTF();
            Object value = ois.readObject();
            PropertyChangeImpl pc = new PropertyChangeImpl(componentPath, propertyName, value);
            result.add(pc);
        }
        return result;
    }

    public void setClassResolver(ClassResolver resolver) {
        this._classResolver = resolver;
    }
}

