/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.util.Defense;
import org.apache.hivemind.util.PropertyUtils;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.form.validator.BeanValidatorWrapper;
import org.apache.tapestry.form.validator.Validator;
import org.apache.tapestry.form.validator.ValidatorContribution;
import org.apache.tapestry.form.validator.ValidatorFactory;
import org.apache.tapestry.form.validator.ValidatorMessages;
import org.apache.tapestry.util.RegexpMatch;
import org.apache.tapestry.util.RegexpMatcher;

public class ValidatorFactoryImpl
implements ValidatorFactory {
    private static final String PATTERN = "^\\s*(\\$?\\w+)\\s*(=\\s*(((?!,|\\[).)*))?";
    private Map _validators;

    public List constructValidatorList(IComponent component, String specification) {
        Defense.notNull((Object)component, (String)"component");
        if (HiveMind.isBlank((String)specification)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Validator> result = new ArrayList<Validator>();
        String chopped = specification;
        RegexpMatcher matcher = new RegexpMatcher();
        while (chopped.length() != 0) {
            RegexpMatch[] matches;
            if (!result.isEmpty()) {
                if (chopped.charAt(0) != ',') {
                    throw new ApplicationRuntimeException(ValidatorMessages.badSpecification(specification));
                }
                chopped = chopped.substring(1);
            }
            if ((matches = matcher.getMatches(PATTERN, chopped)).length != 1) {
                throw new ApplicationRuntimeException(ValidatorMessages.badSpecification(specification));
            }
            RegexpMatch match = matches[0];
            String name = match.getGroup(1);
            String value = match.getGroup(3);
            String message = null;
            int length = match.getMatchLength();
            if (chopped.length() > length) {
                char lastChar = chopped.charAt(length);
                if (lastChar == ',') {
                    --length;
                } else if (lastChar == '[') {
                    int messageClose = chopped.indexOf(93, length);
                    message = chopped.substring(length + 1, messageClose);
                    length = messageClose;
                }
            }
            Validator validator = this.buildValidator(component, name, value, message);
            result.add(validator);
            if (length >= chopped.length()) break;
            chopped = chopped.substring(length + 1);
        }
        return Collections.unmodifiableList(result);
    }

    private Validator buildValidator(IComponent component, String name, String value, String message) {
        if (name.startsWith("$")) {
            return this.extractValidatorBean(component, name, value, message);
        }
        ValidatorContribution vc = (ValidatorContribution)this._validators.get(name);
        if (vc == null) {
            throw new ApplicationRuntimeException(ValidatorMessages.unknownValidator(name));
        }
        if (value == null && vc.isConfigurable()) {
            throw new ApplicationRuntimeException(ValidatorMessages.needsConfiguration("name"));
        }
        if (value != null && !vc.isConfigurable()) {
            throw new ApplicationRuntimeException(ValidatorMessages.notConfigurable(name, value));
        }
        try {
            Object result = vc.getValidatorClass().newInstance();
            if (vc.isConfigurable()) {
                PropertyUtils.smartWrite(result, (String)name, (String)value);
            }
            if (message != null) {
                PropertyUtils.write(result, (String)"message", (Object)message);
            }
            return (Validator)result;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ValidatorMessages.errorInitializingValidator(name, vc.getValidatorClass(), ex), (Throwable)ex);
        }
    }

    private Validator extractValidatorBean(IComponent component, String validatorName, String value, String message) {
        String beanName = validatorName.substring(1);
        if (HiveMind.isNonBlank((String)value) || HiveMind.isNonBlank((String)message)) {
            throw new ApplicationRuntimeException(ValidatorMessages.noValueOrMessageForBean(beanName));
        }
        return new BeanValidatorWrapper(component, beanName);
    }

    public void setValidators(Map validators) {
        this._validators = validators;
    }
}

