/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form.translator;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.Locale;
import org.apache.hivemind.util.PropertyUtils;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.TapestryUtils;
import org.apache.tapestry.form.FormComponentContributorContext;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.form.translator.FormatTranslator;
import org.apache.tapestry.valid.ValidationConstraint;

public class NumberTranslator
extends FormatTranslator {
    private boolean _omitZero = true;

    public NumberTranslator() {
    }

    protected String formatObject(IFormComponent field, Locale locale, Object object) {
        Number number = (Number)object;
        if (this._omitZero && number.doubleValue() == 0.0) {
            return "";
        }
        return super.formatObject(field, locale, object);
    }

    public NumberTranslator(String initializer) {
        PropertyUtils.configureProperties((Object)this, (String)initializer);
    }

    protected String defaultScript() {
        return "/org/apache/tapestry/form/translator/NumberTranslator.js";
    }

    protected String defaultPattern() {
        return "#";
    }

    protected Format getFormat(Locale locale) {
        return this.getDecimalFormat(locale);
    }

    public DecimalFormat getDecimalFormat(Locale locale) {
        return new DecimalFormat(this.getPattern(), new DecimalFormatSymbols(locale));
    }

    protected String getMessageKey() {
        return "invalid-numeric-format";
    }

    protected Object[] getMessageParameters(Locale locale, String label) {
        String pattern = this.getDecimalFormat(locale).toLocalizedPattern();
        return new Object[]{label, pattern};
    }

    public void renderContribution(IMarkupWriter writer, IRequestCycle cycle, FormComponentContributorContext context, IFormComponent field) {
        super.renderContribution(writer, cycle, context, field);
        String message = TapestryUtils.enquote(this.buildMessage(context, field, this.getMessageKey()));
        context.addSubmitHandler("function(event) { Tapestry.validate_number(event, '" + field.getClientId() + "', " + message + "); }");
    }

    protected ValidationConstraint getConstraint() {
        return ValidationConstraint.NUMBER_FORMAT;
    }

    public void setOmitZero(boolean omitZero) {
        this._omitZero = omitZero;
    }
}

