/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.EngineMessages;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.services.LinkFactory;

public class RestartService
implements IEngineService {
    private Log _log;
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private LinkFactory _linkFactory;
    private String _servletPath;

    public ILink getLink(boolean post, Object parameter) {
        if (parameter != null) {
            throw new IllegalArgumentException(EngineMessages.serviceNoParameter(this));
        }
        HashMap parameters = new HashMap();
        return this._linkFactory.constructLink(this, post, parameters, true);
    }

    public void service(IRequestCycle cycle) throws IOException {
        HttpSession session = this._request.getSession(false);
        if (session != null) {
            try {
                session.invalidate();
            }
            catch (IllegalStateException ex) {
                this._log.warn((Object)"Exception thrown invalidating HttpSession.", (Throwable)ex);
            }
        }
        String url = cycle.getAbsoluteURL(this._servletPath);
        this._response.sendRedirect(url);
    }

    public String getName() {
        return "restart";
    }

    public void setLog(Log log) {
        this._log = log;
    }

    public void setRequest(HttpServletRequest request) {
        this._request = request;
    }

    public void setResponse(HttpServletResponse response) {
        this._response = response;
    }

    public void setLinkFactory(LinkFactory linkFactory) {
        this._linkFactory = linkFactory;
    }

    public void setServletPath(String servletPath) {
        this._servletPath = servletPath;
    }
}

