/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.bean;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.tapestry.IBeanProvider;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.bean.BeanMessages;
import org.apache.tapestry.bean.IBeanInitializer;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEndRenderListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.services.ClassFinder;
import org.apache.tapestry.services.Infrastructure;
import org.apache.tapestry.spec.BeanLifecycle;
import org.apache.tapestry.spec.IBeanSpecification;
import org.apache.tapestry.spec.IComponentSpecification;

public class BeanProvider
implements IBeanProvider,
PageDetachListener,
PageEndRenderListener {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$bean$BeanProvider == null ? (class$org$apache$tapestry$bean$BeanProvider = BeanProvider.class$("org.apache.tapestry.bean.BeanProvider")) : class$org$apache$tapestry$bean$BeanProvider));
    private boolean _registeredForDetach = false;
    private boolean _registeredForRender = false;
    private final IComponent _component;
    private final ClassResolver _resolver;
    private final ClassFinder _classFinder;
    private final String _packageList;
    private Map _beans;
    private Set _beanNames;
    static /* synthetic */ Class class$org$apache$tapestry$bean$BeanProvider;

    public BeanProvider(IComponent component) {
        this._component = component;
        Infrastructure infrastructure = component.getPage().getRequestCycle().getInfrastructure();
        this._resolver = infrastructure.getClassResolver();
        INamespace namespace = component.getNamespace();
        this._packageList = namespace.getPropertyValue("org.apache.tapestry.bean-class-packages");
        this._classFinder = infrastructure.getClassFinder();
    }

    public Collection getBeanNames() {
        if (this._beanNames == null) {
            Collection c = this._component.getSpecification().getBeanNames();
            this._beanNames = c == null || c.isEmpty() ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(c));
        }
        return this._beanNames;
    }

    public IComponent getComponent() {
        return this._component;
    }

    public Object getBean(String name) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getBean(" + name + ")"));
        }
        Object bean = null;
        if (this._beans != null) {
            bean = this._beans.get(name);
        }
        if (bean != null) {
            return bean;
        }
        IBeanSpecification spec = this._component.getSpecification().getBeanSpecification(name);
        if (spec == null) {
            throw new ApplicationRuntimeException(BeanMessages.beanNotDefined(this._component, name));
        }
        bean = this.instantiateBean(name, spec);
        BeanLifecycle lifecycle = spec.getLifecycle();
        if (lifecycle == BeanLifecycle.NONE) {
            return bean;
        }
        if (this._beans == null) {
            this._beans = new HashMap();
        }
        this._beans.put(name, bean);
        if (lifecycle == BeanLifecycle.REQUEST && !this._registeredForDetach) {
            this._component.getPage().addPageDetachListener(this);
            this._registeredForDetach = true;
        }
        if (lifecycle == BeanLifecycle.RENDER && !this._registeredForRender) {
            this._component.getPage().addPageEndRenderListener(this);
            this._registeredForRender = true;
        }
        return bean;
    }

    Object instantiateBean(String beanName, IBeanSpecification spec) {
        Class beanClass;
        String className = spec.getClassName();
        Object bean = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Instantiating instance of " + className));
        }
        if ((beanClass = this._classFinder.findClass(this._packageList, className)) == null) {
            throw new ApplicationRuntimeException(BeanMessages.missingBeanClass(this._component, beanName, className, this._packageList), (Object)this._component, spec.getLocation(), null);
        }
        try {
            bean = beanClass.newInstance();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(BeanMessages.instantiationError(beanName, this._component, beanClass, ex), (Object)this._component, spec.getLocation(), (Throwable)ex);
        }
        List initializers = spec.getInitializers();
        if (initializers == null) {
            return bean;
        }
        Iterator i = initializers.iterator();
        while (i.hasNext()) {
            IBeanInitializer iz = (IBeanInitializer)i.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Initializing property " + iz.getPropertyName()));
            }
            try {
                iz.setBeanProperty(this, bean);
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException(BeanMessages.initializationError(this._component, beanName, iz.getPropertyName(), ex), bean, iz.getLocation(), (Throwable)ex);
            }
        }
        return bean;
    }

    public void pageDetached(PageEvent event) {
        this.removeBeans(BeanLifecycle.REQUEST);
    }

    private void removeBeans(BeanLifecycle lifecycle) {
        if (this._beans == null) {
            return;
        }
        IComponentSpecification spec = null;
        Iterator i = this._beans.entrySet().iterator();
        while (i.hasNext()) {
            IBeanSpecification s;
            Map.Entry e = i.next();
            String name = (String)e.getKey();
            if (spec == null) {
                spec = this._component.getSpecification();
            }
            if ((s = spec.getBeanSpecification(name)).getLifecycle() != lifecycle) continue;
            Object bean = e.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing " + lifecycle.getName() + " bean " + name + ": " + bean));
            }
            i.remove();
        }
    }

    public ClassResolver getClassResolver() {
        return this._resolver;
    }

    public void pageEndRender(PageEvent event) {
        this.removeBeans(BeanLifecycle.RENDER);
    }

    public boolean canProvideBean(String name) {
        return this.getBeanNames().contains(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

