/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.asset;

import java.util.Locale;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.asset.AssetFactory;
import org.apache.tapestry.asset.AssetMessages;
import org.apache.tapestry.asset.PrivateAsset;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.l10n.ResourceLocalizer;

public class ClasspathAssetFactory
implements AssetFactory {
    private ClassResolver _classResolver;
    private IEngineService _assetService;
    private ResourceLocalizer _localizer;

    public IAsset createAsset(Resource baseResource, String path, Locale locale, Location location) {
        Resource asset = baseResource.getRelativeResource(path);
        Resource localized = this._localizer.findLocalization(asset, locale);
        if (localized == null) {
            throw new ApplicationRuntimeException(AssetMessages.missingAsset(path, baseResource), location, null);
        }
        return this.createAsset(localized, location);
    }

    public IAsset createAbsoluteAsset(String path, Locale locale, Location location) {
        ClasspathResource base = new ClasspathResource(this._classResolver, path);
        Resource localized = this._localizer.findLocalization((Resource)base, locale);
        if (localized == null) {
            throw new ApplicationRuntimeException(AssetMessages.missingClasspathResource(path), location, null);
        }
        return this.createAsset(localized, location);
    }

    public IAsset createAsset(Resource resource, Location location) {
        ClasspathResource cr = (ClasspathResource)resource;
        return new PrivateAsset(cr, this._assetService, location);
    }

    public void setAssetService(IEngineService assetService) {
        this._assetService = assetService;
    }

    public void setClassResolver(ClassResolver classResolver) {
        this._classResolver = classResolver;
    }

    public void setLocalizer(ResourceLocalizer localizer) {
        this._localizer = localizer;
    }
}

