/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.asset;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hivemind.Location;
import org.apache.hivemind.Resource;
import org.apache.hivemind.util.Defense;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.asset.AssetFactory;
import org.apache.tapestry.asset.AssetFactoryContribution;
import org.apache.tapestry.asset.AssetSource;

public class AssetSourceImpl
implements AssetSource {
    private Map _assetFactoryByPrefix = new HashMap();
    private List _contributions;
    private AssetFactory _defaultAssetFactory;
    private AssetFactory _lookupAssetFactory;

    public void initializeService() {
        Iterator i = this._contributions.iterator();
        while (i.hasNext()) {
            AssetFactoryContribution c = (AssetFactoryContribution)((Object)i.next());
            this._assetFactoryByPrefix.put(c.getPrefix(), c.getFactory());
        }
    }

    public IAsset findAsset(Resource base, String path, Locale locale, Location location) {
        Defense.notNull((Object)base, (String)"base");
        Defense.notNull((Object)path, (String)"path");
        Defense.notNull((Object)location, (String)"location");
        int colonx = path.indexOf(58);
        if (colonx < 0) {
            return this._lookupAssetFactory.createAsset(base, path, locale, location);
        }
        String prefix = path.substring(0, colonx);
        String truePath = path.substring(colonx + 1);
        AssetFactory factory = (AssetFactory)this._assetFactoryByPrefix.get(prefix);
        if (factory == null) {
            factory = this._defaultAssetFactory;
            truePath = path;
        }
        if (truePath.startsWith("/")) {
            return factory.createAbsoluteAsset(truePath, locale, location);
        }
        return factory.createAsset(base, truePath, locale, location);
    }

    public void setLookupAssetFactory(AssetFactory lookupAssetFactory) {
        this._lookupAssetFactory = lookupAssetFactory;
    }

    public void setContributions(List contributions) {
        this._contributions = contributions;
    }

    public void setDefaultAssetFactory(AssetFactory defaultAssetFactory) {
        this._defaultAssetFactory = defaultAssetFactory;
    }
}

