/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.util.ClassAdaptor;
import org.apache.hivemind.util.PropertyAdaptor;
import org.apache.hivemind.util.UtilMessages;

public class PropertyUtils {
    private static final Map _classAdaptors = new HashMap();

    private PropertyUtils() {
    }

    public static void write(Object target, String propertyName, Object value) {
        ClassAdaptor a = PropertyUtils.getAdaptor(target);
        a.write(target, propertyName, value);
    }

    public static void smartWrite(Object target, String propertyName, String value) {
        ClassAdaptor a = PropertyUtils.getAdaptor(target);
        a.smartWrite(target, propertyName, value);
    }

    public static void configureProperties(Object target, String initializer) {
        ClassAdaptor a = PropertyUtils.getAdaptor(target);
        a.configureProperties(target, initializer);
    }

    public static boolean isWritable(Object target, String propertyName) {
        return PropertyUtils.getAdaptor(target).isWritable(propertyName);
    }

    public static boolean isReadable(Object target, String propertyName) {
        return PropertyUtils.getAdaptor(target).isReadable(propertyName);
    }

    public static Object read(Object target, String propertyName) {
        ClassAdaptor a = PropertyUtils.getAdaptor(target);
        return a.read(target, propertyName);
    }

    public static Class getPropertyType(Object target, String propertyName) {
        ClassAdaptor a = PropertyUtils.getAdaptor(target);
        return a.getPropertyType(target, propertyName);
    }

    public static PropertyAdaptor getPropertyAdaptor(Object target, String propertyName) {
        ClassAdaptor a = PropertyUtils.getAdaptor(target);
        return a.getPropertyAdaptor(target, propertyName);
    }

    public static List getReadableProperties(Object target) {
        return PropertyUtils.getAdaptor(target).getReadableProperties();
    }

    public static List getWriteableProperties(Object target) {
        return PropertyUtils.getAdaptor(target).getWriteableProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassAdaptor getAdaptor(Object target) {
        if (target == null) {
            throw new ApplicationRuntimeException(UtilMessages.nullObject());
        }
        Class<?> targetClass = target.getClass();
        Object object = HiveMind.INTROSPECTOR_MUTEX;
        synchronized (object) {
            ClassAdaptor result = (ClassAdaptor)_classAdaptors.get(targetClass);
            if (result == null) {
                result = PropertyUtils.buildClassAdaptor(target, targetClass);
                _classAdaptors.put(targetClass, result);
            }
            return result;
        }
    }

    private static ClassAdaptor buildClassAdaptor(Object target, Class targetClass) {
        try {
            BeanInfo info = Introspector.getBeanInfo(targetClass);
            return new ClassAdaptor(info.getPropertyDescriptors());
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(UtilMessages.unableToIntrospect(targetClass, ex), target, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Object object = HiveMind.INTROSPECTOR_MUTEX;
        synchronized (object) {
            _classAdaptors.clear();
            Introspector.flushCaches();
        }
    }
}

