/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.conditional;

import org.apache.hivemind.conditional.AndEvaluator;
import org.apache.hivemind.conditional.ClassNameEvaluator;
import org.apache.hivemind.conditional.ConditionalMessages;
import org.apache.hivemind.conditional.Evaluator;
import org.apache.hivemind.conditional.Lexer;
import org.apache.hivemind.conditional.Node;
import org.apache.hivemind.conditional.NodeImpl;
import org.apache.hivemind.conditional.NotEvaluator;
import org.apache.hivemind.conditional.OrEvaluator;
import org.apache.hivemind.conditional.PropertyEvaluator;
import org.apache.hivemind.conditional.Token;
import org.apache.hivemind.conditional.TokenType;
import org.apache.hivemind.util.Defense;

public class Parser {
    private String _input;
    private Lexer _lexer;
    private Token _nextToken;
    private boolean _onDeck;
    private static final Evaluator NOT_EVALUATOR = new NotEvaluator();
    private static final Evaluator OR_EVALUATOR = new OrEvaluator();
    private static final Evaluator AND_EVALUATOR = new AndEvaluator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node parse(String input) {
        Defense.notNull(input, "input");
        try {
            this._input = input;
            this._lexer = new Lexer(input);
            Node result = this.expression();
            Token token = this.next();
            if (token != null) {
                throw new RuntimeException(ConditionalMessages.unparsedToken(token, this._input));
            }
            Node node = result;
            return node;
        }
        finally {
            this._input = null;
            this._nextToken = null;
            this._lexer = null;
            this._onDeck = false;
        }
    }

    private Token next() {
        Token result = this._onDeck ? this._nextToken : this._lexer.next();
        this._onDeck = false;
        this._nextToken = null;
        return result;
    }

    private Token match(TokenType expected) {
        Token actual = this.next();
        if (actual == null) {
            throw new RuntimeException(ConditionalMessages.unexpectedEndOfInput(this._input));
        }
        if (actual.getType() != expected) {
            throw new RuntimeException(ConditionalMessages.unexpectedToken(expected, actual.getType(), this._input));
        }
        return actual;
    }

    private Token peek() {
        if (!this._onDeck) {
            this._nextToken = this._lexer.next();
            this._onDeck = true;
        }
        return this._nextToken;
    }

    private TokenType peekType() {
        Token next = this.peek();
        return next == null ? null : next.getType();
    }

    private boolean isPeek(TokenType type) {
        return this.peekType() == type;
    }

    private Node expression() {
        Node lnode = this.term();
        if (this.isPeek(TokenType.OR)) {
            this.next();
            Node rnode = this.expression();
            return new NodeImpl(lnode, rnode, OR_EVALUATOR);
        }
        if (this.isPeek(TokenType.AND)) {
            this.next();
            Node rnode = this.expression();
            return new NodeImpl(lnode, rnode, AND_EVALUATOR);
        }
        return lnode;
    }

    private Node term() {
        if (this.isPeek(TokenType.OPAREN)) {
            this.next();
            Node result = this.expression();
            this.match(TokenType.CPAREN);
            return result;
        }
        if (this.isPeek(TokenType.NOT)) {
            this.next();
            this.match(TokenType.OPAREN);
            Node expression = this.expression();
            this.match(TokenType.CPAREN);
            return new NodeImpl(expression, null, NOT_EVALUATOR);
        }
        if (this.isPeek(TokenType.PROPERTY)) {
            this.next();
            Token symbolToken = this.match(TokenType.SYMBOL);
            PropertyEvaluator ev = new PropertyEvaluator(symbolToken.getValue());
            return new NodeImpl(ev);
        }
        if (this.isPeek(TokenType.CLASS)) {
            this.next();
            Token symbolToken = this.match(TokenType.SYMBOL);
            ClassNameEvaluator ev = new ClassNameEvaluator(symbolToken.getValue());
            return new NodeImpl(ev);
        }
        throw new RuntimeException(ConditionalMessages.unparsedToken(this.next(), this._input));
    }
}

