################################################################################
#
# ץ饰μ
#
################################################################################
package Wiki::Plugin;

BEGIN {
	# ѥ饰եץ饰Υȥ
	$main::P_PLUGIN->{recent}        = \&Wiki::Plugin::recent;
	$main::P_PLUGIN->{category_list} = \&Wiki::Plugin::category_list;
	$main::P_PLUGIN->{ref_image}     = \&Wiki::Plugin::ref_image;
	$main::P_PLUGIN->{ref_text}      = \&Wiki::Plugin::ref_text;
	
	# 饤ץ饰Υȥ
	$main::I_PLUGIN->{category}     = \&Wiki::Plugin::category;
	$main::I_PLUGIN->{lastmodified} = \&Wiki::Plugin::lastmodified;
	$main::I_PLUGIN->{ref}          = \&Wiki::Plugin::ref;
}

#==============================================================================
# ڡΰ򹹿ɽץ饰
#==============================================================================
sub recent {
	my $max = shift;
	$max = 0 if($max eq "");
	my $buf = "";
	
	my @pages = &Wiki::get_page_list();
	my $count = 0;
	
	$buf .= "<ul>\n";
	foreach my $page (@pages){
		$buf .= "<li><a href=\"$main::MAIN_SCRIPT?p=".&Util::url_encode($page->{NAME})."\">".
		        &Util::escapeHTML($page->{NAME})."</a></li>\n";
		$count++;
		last if($count==$max && $max!=0);
	}
	$buf .= "</ul>\n";
	
	return $buf;
}

#==============================================================================
# ڡ򥫥ƥ饤뤿Υץ饰
#==============================================================================
sub category {
	my $category = shift;
	if($category eq ""){
		return "ƥ꤬ꤵƤޤ";
	} else {
		return "[<a href=\"$main::CATEGORY_SCRIPT?c=".&Util::url_encode($category)."\">".
		       "ƥ:".&Util::escapeHTML($category)."</a>]";
	}
}

#=============================================================================
# ڡκǽɽץ饰
#=============================================================================
sub lastmodified {
	my $page = $main::in{"p"};
	if(&Wiki::exists_page($page)){
		return  "ǽ֡".&Util::format_date(&Wiki::get_last_modified($page));
	} else {
		return undef;
	}
}

#=============================================================================
# ƥꤴȤΥڡɽץ饰
#=============================================================================
sub category_list {
	my $category = shift;
	my $buf      = "";
	
	# ꤵ줿ƥɽ
	if($category ne ""){
		my @pages = &Wiki::get_page_list();
		$buf .= "<h2>".&Util::escapeHTML($category)."</h2>\n";
		$buf .= "<ul>\n";
		foreach my $page (sort(@pages)){
			my $source = &Wiki::get_page($page->{NAME});
			foreach my $line (split(/\n/,$source)){
				# ȤѥƥȤξФ
				next if($line =~ /^(\t| |\/\/)/);
				
				# ƥ˥ޥåꥹƥ
				if($line =~ /{{category\s+$category}}/){
					$buf .= "<li><a href=\"$main::MAIN_SCRIPT?p=".&Util::url_encode($page->{NAME})."\">".
					        &Util::escapeHTML($page->{NAME})."</a></li>";
					last;
				}
			}
		}
		$buf .= "</ul>\n";
	
	# ƤΥƥɽ
	} else {
		my $category = {};
		my @pages = &Wiki::get_page_list();
		
		foreach my $page (@pages){
			my $source = &Wiki::get_page($page->{NAME});
			foreach my $line (split(/\n/,$source)){
				# ȤѥƥȤξФ
				next if($line =~ /^(\t| |\/\/)/);
				
				# ƥ˥ޥåꥹƥ
				while($line =~ /{{category\s+(.+?)}}/g){
					$category->{$1}->{$page->{NAME}} = 1;
				}
			}
		}
		
		foreach my $name (sort(keys(%$category))){
			$buf .= "<h2>".&Util::escapeHTML($name)."</h2>\n";
			$buf .= "<ul>\n";
			foreach my $page (sort(keys(%{$category->{$name}}))){
				$buf .= "<li><a href=\"$main::MAIN_SCRIPT?p=".&Util::url_encode($page)."\">".
				      &Util::escapeHTML($page)."</a></li>\n";
			}
			$buf .= "</ul>\n";
		}
	}
	return $buf;
}

#=============================================================================
# źեեؤΥ󥯤ɽ뤿Υץ饰
#=============================================================================
sub ref {
	my $page = $main::in{"p"};
	my $file = shift;
	
	if($file eq ""){
		return "ե뤬ꤵƤޤ";
	}
	
	my $filename = sprintf("$main::ATTACH_DIR/%s.%s",
						   &Util::url_encode($page),&Util::url_encode($file));
	unless(-e $filename){
		return "ե뤬¸ߤޤ";
	}
	
	return sprintf("<a href=\"$main::DOWNLOAD_SCRIPT?p=%s&f=%s\">%s</a>",
	               &Util::url_encode($page),&Util::url_encode($file),$file);
}

#=============================================================================
# źեեȤɽ뤿Υץ饰
#=============================================================================
sub ref_image {
	my $page = $main::in{"p"};
	my $file = shift;
	
	if($file eq ""){
		return "ե뤬ꤵƤޤ";
	}
	
	my $filename = sprintf("$main::ATTACH_DIR/%s.%s",
						   &Util::url_encode($page),&Util::url_encode($file));
	unless(-e $filename){
		return "<p>ե뤬¸ߤޤ</p>\n";
	}
	
	return sprintf("<div><img src=\"$main::DOWNLOAD_SCRIPT?p=%s&f=%s\"></div>",
	               &Util::url_encode($page),&Util::url_encode($file));
}

#=============================================================================
# źեեȤɽ뤿Υץ饰
#=============================================================================
sub ref_text {
	my $page = $main::in{"p"};
	my $file = shift;
	
	if($file eq ""){
		return "ե뤬ꤵƤޤ";
	}
	
	my $filename = sprintf("$main::ATTACH_DIR/%s.%s",
						   &Util::url_encode($page),&Util::url_encode($file));
	unless(-e $filename){
		return "<p>ե뤬¸ߤޤ</p>\n";
	}
	
	my $text = "";
	open(DATA,$filename);
	while(<DATA>){
		$text .= $_;
	}
	close(DATA);
	
	# ԥɤѴ
	$text =~ s/\r\n/\n/g;
	$text =~ s/\r/\n/g;
	# ʸɤѴ
	&jcode::convert(\$text,"euc");
	
	# preĤֵ
	return "<pre>".&Util::escapeHTML($text)."</pre>\n";
}

1;
