###############################################################################
#
# InterWikiNameΥѡ
#
###############################################################################
package Wiki::InterWiki;
#use strict;

#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $wiki  = shift;
	
	my $self  = {};
	$self->{wiki} = $wiki;
	$self->{interwiki} = [];
	bless $self,$class;

	$self->parse;
	return bless $self;
}

#==============================================================================
# ǥХå
#==============================================================================
sub print_string {
	my $self = shift;
	my @keywords = @{$self->{interwiki}};
	foreach(@keywords){
		print $_->{label},"-",$_->{url},"-",$_->{enc},"\n";
	}
}

#==============================================================================
# ѡʥ󥹥ȥ饯ƤФޤ
#==============================================================================
sub parse {
	my $self = shift;
	my $wiki = $self->{wiki};
	if($wiki->page_exists("InterWikiName")){
		my $source = $wiki->get_page("InterWikiName");
		$source =~ s/\r//g;
		my @lines = split(/\n/,$source);
		foreach my $line (@lines){
			if(index($line,"*")==0){
				$self->parse_line($line);
			}
		}
	}
}

#==============================================================================
# Ԥѡ
#==============================================================================
sub parse_line {
	my $self   = shift;
	my $source = shift;
	# ̾
	if($source =~ /\[([^\[]+?)\|((http|https|ftp):[a-zA-Z0-9\.%~^_+\-%\/\?\(\)!\$&=:;\*#@]*?)\]\s*([A-Za-z_\-]+)/){
		my $label = $1;
		my $url   = $2;
		my $enc   = $4;
		$self->add_inter_wiki($url,$label,$enc);
	
	# ʸɤλʤ
	} elsif($source =~ /\[([^\[]+?)\|((http|https|ftp):[a-zA-Z0-9\.%~^_+\-%\/\?\(\)!\$&=:;\*#@]*?)\]/){
		my $label = $1;
		my $url   = $2;
		my $enc   = "";
		$self->add_inter_wiki($url,$label,$enc);
	}

}

#==============================================================================
# InterWikiNameɲ
#==============================================================================
sub add_inter_wiki {
	my $self  = shift;
	my $url   = shift;
	my $label = shift;
	my $enc   = shift;
	push(@{$self->{interwiki}},{label=>$label,url=>$url,enc=>$enc});
}

#==============================================================================
# InterWikiNameޤޤ뤫ɤå
#==============================================================================
sub exists_interwiki {
	my $self = shift;
	my $str  = shift;
	
	my @keywords = @{$self->{interwiki}};
	
	foreach(@keywords){
		my $label = $_->{label};
		if($str =~ /\[\[$label:(.+?)\]\]/){
			$self->{g_pre}   = $`;
			$self->{g_post}  = $';
			my $enc   = $_->{enc};
			my $param = $1;
			$self->{g_label} = $label.":".$param;
			if($enc ne ""){
				&Jcode::convert(\$param,$enc);
			}
			$self->{g_url} = $_->{url}.Util::url_encode($param);
			return 1;
			
		} elsif($str =~ /\[\[([^\[]+?)\|$label:(.+?)\]\]/){
			$self->{g_pre}   = $`;
			$self->{g_post}  = $';
			$self->{g_label} = $1;
			my $enc   = $_->{enc};
			my $param = $2;
			if($enc ne ""){
				&Jcode::convert(\$param,$enc);
			}
			$self->{g_url} = $_->{url}.Util::url_encode($param);
			return 1;
			
		}
	}
	return 0;
}

1;
