################################################################################
#
# Хȥåץ饰Υϥɥ顣
# 
################################################################################
package plugin::bugtrack::BugTrackHandler;
use strict;
#===============================================================================
# 󥹥ȥ饯
#===============================================================================
sub new {
	my $class = shift;
	my $self = {};
	return bless $self,$class;
}

#==============================================================================
# ϥɥ
#==============================================================================
sub do_action {
	my $self = shift;
	my $wiki = shift;
	my $cgi = $wiki->get_CGI;
	
	my $project  = $cgi->param("project");
	my $name     = $cgi->param("name");
	my $category = $cgi->param("category");
	my $priority = $cgi->param("priority");
	my $status   = $cgi->param("status");
	my $content  = $cgi->param("content");
	my $subject  = $cgi->param("subject");
	my $time     = time();
	
	if($name eq ""){
		return $wiki->error("̾ϤƤޤ");
	} elsif($subject eq ""){
		return $wiki->error("ޥ꤬ϤƤޤ");
	} elsif($content eq ""){
		return $wiki->error("ХƤϤƤޤ");
	}
	
	my $page = $self->make_pagename($wiki,$project);
	
	$content = "!!!$subject\n".
	           "*Ƽԡ $name\n".
	           "*ƥꡧ $category\n".
	           "*ͥ١ $priority\n".
	           "*֡ $status\n".
	           "* ".Util::format_date($time)."\n".
	           "{{bugstate}}\n".
	           "!!\n".$content."\n".
	           "!!\n{{comment}}";
	
	$wiki->save_page($page,$content);
	$cgi->param("page",$page);
	$wiki->call_handler("");
}

#==============================================================================
# ХݡȤΥڡ̾
#==============================================================================
sub make_pagename {
	my $self = shift;
	my $wiki = shift;
	my $project = shift;
	
	my @list = $wiki->get_page_list;
	my $count = 0;
	foreach(@list){
		if($_ =~ /^BugTrack-$project\/([0-9]+)$/){
			if($count < $1){
				$count = $1;
			}
		}
	}
	$count++;
	return "BugTrack-$project/$count";
}

1;
