###############################################################################
# 
# ʬɽץ饰
# 
###############################################################################
package plugin::core::Diff;
use Algorithm::Diff qw(traverse_sequences);
#use strict;

#==============================================================================
# ⥸塼ǻѤѿ
#==============================================================================
my $diff_text;
my $msgrefA;
my $msgrefB;
my @diff_added;
my @diff_deleted;

#==============================================================================
# 󥹥ȥ饯
#==============================================================================
sub new {
	my $class = shift;
	my $self = {};
	
	# ⥸塼ѿ
	$diff_text    = "";
	$msgrefA      = "";
	$msgrefB      = "";
	@diff_added   = ();
	@diff_deleted = ();
	
	return bless $self,$class;
}

#==============================================================================
# μ¹
#==============================================================================
sub do_action {
	my $self = shift;
	my $wiki = shift;
	my $cgi = $wiki->get_CGI;
	
	my $pagename = $cgi->param("page");
	if($pagename eq ""){
		$pagename = $wiki->config("frontpage");
	}
	unless($wiki->can_show($pagename)){
		return $wiki->error("ȸ¤ޤ");
	}
	if($wiki->{storage}->backup_type eq "all"){
		if($cgi->param("generation") eq ""){
			return $self->show_history($wiki,$pagename);
		} else {
			return $self->show_diff($wiki,$pagename,$cgi->param("generation"));
		}
	} else {
		return $self->show_diff($wiki,$pagename,0);
	}
}

#==============================================================================
# ΰɽ
# ȥ졼backup_type=allΤȤ
#==============================================================================
sub show_history {
	my $self = shift;
	my $wiki = shift;
	my $pagename = shift;
	
	$wiki->set_title($pagename."ѹ");
	my $buf   = "<ul>\n";
	my $count = 0;
	my @list  = $wiki->{storage}->get_backup_list($pagename);
	foreach my $time (@list){
		$buf .= "<li><a href=\"".$wiki->config('script_name')."?action=DIFF".
		        "&page=".&Util::url_encode($pagename).
		        "&generation=".($#list-$count)."\">".&Util::escapeHTML($time).
		        "</a><a href=\"".$wiki->config('script_name')."?action=SOURCE".
		        "&page=".&Util::url_encode($pagename).
		        "&generation=".($#list-$count)."\"></a>".
		        "</li>\n";
		$count++;
	}
	return $buf."</ul>\n";
}

#==============================================================================
# ʬɽ
#==============================================================================
sub show_diff {
	my $self       = shift;
	my $wiki       = shift;
	my $pagename   = shift;
	my $generation = shift;
	
	$wiki->set_title($pagename."ѹ");
	$self->get_diff_text($wiki,$pagename,$generation);
	
	return "<pre>".Util::escapeHTML($diff_text)."</pre>";
}

#==============================================================================
# ʬʸ
#==============================================================================
sub get_diff_text {
	my $self       = shift;
	my $wiki       = shift;
	my $pagename   = shift;
	my $generation = shift;
	
	my $source1 = $wiki->get_page($pagename);
	my $source2 = $wiki->get_backup($pagename,$generation);
	my $format  = $wiki->get_edit_format();
	
	$source1 = $wiki->convert_from_fswiki($source1,$format);
	$source2 = $wiki->convert_from_fswiki($source2,$format);
	
	my @msg1 = split(/\n/,$source1);
	my @msg2 = split(/\n/,$source2);
	$msgrefA = \@msg2;
	$msgrefB = \@msg1;
	
	traverse_sequences($msgrefA, $msgrefB,
		{MATCH => \&df_match,DISCARD_A => \&df_delete,DISCARD_B => \&df_add,});
	&diff_flush;
	
	return $diff_text;
}

#==============================================================================
# YukiWikiܿAlgorithm::DiffΥեåؿ
#==============================================================================
sub diff_flush {
    $diff_text .= join('', map { "-$_\n" } splice(@diff_deleted));
    $diff_text .= join('', map { "+$_\n" } splice(@diff_added));
}

sub df_match {
    my ($a, $b) = @_;
    &diff_flush;
    #$diff_text .= "=$msgrefA->[$a]\n";
}

sub df_delete {
    my ($a, $b) = @_;
    push(@diff_deleted, $msgrefA->[$a]);
}

sub df_add {
    my ($a, $b) = @_;
    push(@diff_added, $msgrefB->[$b]);
}

#==============================================================================
# ڡɽΥեå᥽å
# ֺʬץ˥塼ͭˤޤ
#==============================================================================
sub hook {
	my $self = shift;
	my $wiki = shift;
	my $cgi  = $wiki->get_CGI;
	
	my $pagename = $cgi->param("page");
	$wiki->add_menu("ʬ",$wiki->config('script_name')."?action=DIFF&amp;page=".&Util::url_encode($pagename));
}

1;
