/**
 * Library of classes for handling simple shapes.
 *
 * These classes can represent shapes, let you alter them, can go to and from a string
 * representation, and can give you an SVG representation.
 *
 * @package    qtype_ddmarker
 * @subpackage shapes
 * @copyright  2018 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_ddmarker/shapes",(function(){function Point(x,y){this.x=x,this.y=y}function Shape(label,x,y){this.label=label,this.centre=new Point(x||0,y||0)}function Circle(label,x,y,radius){x=x||15,y=y||15,Shape.call(this,label,x,y),this.radius=radius||15}function Rectangle(label,x,y,width,height){Shape.call(this,label,x,y),this.width=width||30,this.height=height||30}function Polygon(label,points){Shape.call(this,label,0,0),this.points=points?points.slice():[new Point(10,10),new Point(40,10),new Point(10,40)],this.normalizeShape(),this.ratio=1}function NullShape(label){Shape.call(this,label)}function createSvgElement(svg,tagName){var svgEl=svg.ownerDocument.createElementNS("http://www.w3.org/2000/svg",tagName);return svg.appendChild(svgEl),svgEl}function createSvgShapeGroup(svg,tagName){var svgEl=createSvgElement(svg,"g");return createSvgElement(svgEl,tagName).setAttribute("class","shape"),createSvgElement(svgEl,"text").setAttribute("class","shapeLabel"),svgEl}return Point.prototype.toString=function(){return this.x+","+this.y},Point.prototype.move=function(dx,dy){this.x+=dx,this.y+=dy},Point.prototype.offset=function(offsetX,offsetY){return offsetX instanceof Point&&(offsetY=offsetX.y,offsetX=offsetX.x),new Point(this.x+offsetX,this.y+offsetY)},Point.parse=function(coordinates){var bits=coordinates.split(",");if(2!==bits.length)throw new Error(coordinates+" is not a valid point");return new Point(Math.round(bits[0]),Math.round(bits[1]))},Shape.prototype.getType=function(){throw new Error("Not implemented.")},Shape.prototype.getCoordinates=function(){throw new Error("Not implemented.")},Shape.prototype.parse=function(coordinates,ratio){throw new Error("Not implemented.")},Shape.prototype.move=function(dx,dy,maxX,maxY){},Shape.prototype.edit=function(handleIndex,dx,dy,maxX,maxY){},Shape.prototype.normalizeShape=function(){},Shape.prototype.makeSvg=function(svg){throw new Error("Not implemented.")},Shape.prototype.updateSvg=function(svgEl){},Shape.prototype.makeSimilarCircle=function(){throw new Error("Not implemented.")},Shape.prototype.makeSimilarRectangle=function(){throw new Error("Not implemented.")},Shape.prototype.makeSimilarPolygon=function(){throw new Error("Not implemented.")},Shape.prototype.getHandlePositions=function(){return null},Circle.prototype=new Shape,Circle.prototype.getType=function(){return"circle"},Circle.prototype.getCoordinates=function(){return this.centre+";"+Math.abs(this.radius)},Circle.prototype.makeSvg=function(svg){var svgEl=createSvgShapeGroup(svg,"circle");return this.updateSvg(svgEl),svgEl},Circle.prototype.updateSvg=function(svgEl){svgEl.childNodes[0].setAttribute("cx",this.centre.x),svgEl.childNodes[0].setAttribute("cy",this.centre.y),svgEl.childNodes[0].setAttribute("r",Math.abs(this.radius)),svgEl.childNodes[1].setAttribute("x",this.centre.x),svgEl.childNodes[1].setAttribute("y",this.centre.y+15),svgEl.childNodes[1].textContent=this.label},Circle.prototype.parse=function(coordinates,ratio){if(!coordinates.match(/^\d+(\.\d+)?,\d+(\.\d+)?;\d+(\.\d+)?$/))return!1;var bits=coordinates.split(";");return this.centre=Point.parse(bits[0]),this.centre.x=this.centre.x*parseFloat(ratio),this.centre.y=this.centre.y*parseFloat(ratio),this.radius=Math.round(bits[1])*parseFloat(ratio),!0},Circle.prototype.move=function(dx,dy,maxX,maxY){this.centre.move(dx,dy),this.centre.x<this.radius&&(this.centre.x=this.radius),this.centre.x>maxX-this.radius&&(this.centre.x=maxX-this.radius),this.centre.y<this.radius&&(this.centre.y=this.radius),this.centre.y>maxY-this.radius&&(this.centre.y=maxY-this.radius)},Circle.prototype.edit=function(handleIndex,dx,dy,maxX,maxY){this.radius+=dx;var limit=Math.min(this.centre.x,this.centre.y,maxX-this.centre.x,maxY-this.centre.y);this.radius>limit&&(this.radius=limit),this.radius<-limit&&(this.radius=-limit)},Circle.prototype.normalizeShape=function(){this.radius=Math.abs(this.radius)},Circle.prototype.makeSimilarRectangle=function(){return new Rectangle(this.label,this.centre.x-this.radius,this.centre.y-this.radius,2*this.radius,2*this.radius)},Circle.prototype.makeSimilarPolygon=function(){return new Polygon(this.label,[this.centre.offset(-this.radius,-this.radius),this.centre.offset(-this.radius,this.radius),this.centre.offset(this.radius,this.radius),this.centre.offset(this.radius,-this.radius)])},Circle.prototype.getHandlePositions=function(){return{moveHandle:this.centre,editHandles:[this.centre.offset(this.radius,0)]}},Rectangle.prototype=new Shape,Rectangle.prototype.getType=function(){return"rectangle"},Rectangle.prototype.getCoordinates=function(){return this.centre+";"+this.width+","+this.height},Rectangle.prototype.makeSvg=function(svg){var svgEl=createSvgShapeGroup(svg,"rect");return this.updateSvg(svgEl),svgEl},Rectangle.prototype.updateSvg=function(svgEl){this.width>=0?(svgEl.childNodes[0].setAttribute("x",this.centre.x),svgEl.childNodes[0].setAttribute("width",this.width)):(svgEl.childNodes[0].setAttribute("x",this.centre.x+this.width),svgEl.childNodes[0].setAttribute("width",-this.width)),this.height>=0?(svgEl.childNodes[0].setAttribute("y",this.centre.y),svgEl.childNodes[0].setAttribute("height",this.height)):(svgEl.childNodes[0].setAttribute("y",this.centre.y+this.height),svgEl.childNodes[0].setAttribute("height",-this.height)),svgEl.childNodes[1].setAttribute("x",this.centre.x+this.width/2),svgEl.childNodes[1].setAttribute("y",this.centre.y+this.height/2+15),svgEl.childNodes[1].textContent=this.label},Rectangle.prototype.parse=function(coordinates,ratio){if(!coordinates.match(/^\d+(\.\d+)?,\d+(\.\d+)?;\d+(\.\d+)?,\d+(\.\d+)?$/))return!1;var bits=coordinates.split(";");this.centre=Point.parse(bits[0]),this.centre.x=this.centre.x*parseFloat(ratio),this.centre.y=this.centre.y*parseFloat(ratio);var size=Point.parse(bits[1]);return this.width=size.x*parseFloat(ratio),this.height=size.y*parseFloat(ratio),!0},Rectangle.prototype.move=function(dx,dy,maxX,maxY){this.centre.move(dx,dy),this.centre.x<0&&(this.centre.x=0),this.centre.x>maxX-this.width&&(this.centre.x=maxX-this.width),this.centre.y<0&&(this.centre.y=0),this.centre.y>maxY-this.height&&(this.centre.y=maxY-this.height)},Rectangle.prototype.edit=function(handleIndex,dx,dy,maxX,maxY){this.width+=dx,this.height+=dy,this.width<-this.centre.x&&(this.width=-this.centre.x),this.width>maxX-this.centre.x&&(this.width=maxX-this.centre.x),this.height<-this.centre.y&&(this.height=-this.centre.y),this.height>maxY-this.centre.y&&(this.height=maxY-this.centre.y)},Rectangle.prototype.normalizeShape=function(){this.width<0&&(this.centre.x+=this.width,this.width=-this.width),this.height<0&&(this.centre.y+=this.height,this.height=-this.height)},Rectangle.prototype.makeSimilarCircle=function(){return new Circle(this.label,Math.round(this.centre.x+this.width/2),Math.round(this.centre.y+this.height/2),Math.round((this.width+this.height)/4))},Rectangle.prototype.makeSimilarPolygon=function(){return new Polygon(this.label,[this.centre,this.centre.offset(0,this.height),this.centre.offset(this.width,this.height),this.centre.offset(this.width,0)])},Rectangle.prototype.getHandlePositions=function(){return{moveHandle:this.centre.offset(this.width/2,this.height/2),editHandles:[this.centre.offset(this.width,this.height)]}},Polygon.prototype=new Shape,Polygon.prototype.getType=function(){return"polygon"},Polygon.prototype.getCoordinates=function(){for(var coordinates="",i=0;i<this.points.length;i++)coordinates+=this.centre.offset(this.points[i])+";";return coordinates.slice(0,coordinates.length-1)},Polygon.prototype.makeSvg=function(svg){var svgEl=createSvgShapeGroup(svg,"polygon");return this.updateSvg(svgEl),svgEl},Polygon.prototype.updateSvg=function(svgEl){svgEl.childNodes[0].setAttribute("points",this.getCoordinates().replace(/[,;]/g," ")),svgEl.childNodes[0].setAttribute("transform","scale("+parseFloat(this.ratio)+")"),svgEl.childNodes[1].setAttribute("x",this.centre.x),svgEl.childNodes[1].setAttribute("y",this.centre.y+15),svgEl.childNodes[1].textContent=this.label},Polygon.prototype.parse=function(coordinates,ratio){if(!coordinates.match(/^\d+(\.\d+)?,\d+(\.\d+)?(?:;\d+(\.\d+)?,\d+(\.\d+)?)*$/))return!1;for(var bits=coordinates.split(";"),points=[],i=0;i<bits.length;i++)points.push(Point.parse(bits[i]));return this.points=points,this.centre.x=0,this.centre.y=0,this.ratio=ratio,this.normalizeShape(),!0},Polygon.prototype.move=function(dx,dy,maxX,maxY){this.centre.move(dx,dy);for(var bbXMin=maxX,bbXMax=0,bbYMin=maxY,bbYMax=0,i=0;i<this.points.length;i++)bbXMin=Math.min(bbXMin,this.points[i].x),bbXMax=Math.max(bbXMax,this.points[i].x),bbYMin=Math.min(bbYMin,this.points[i].y),bbYMax=Math.max(bbYMax,this.points[i].y);this.centre.x<-bbXMin&&(this.centre.x=-bbXMin),this.centre.x>maxX-bbXMax&&(this.centre.x=maxX-bbXMax),this.centre.y<-bbYMin&&(this.centre.y=-bbYMin),this.centre.y>maxY-bbYMax&&(this.centre.y=maxY-bbYMax)},Polygon.prototype.edit=function(handleIndex,dx,dy,maxX,maxY){this.points[handleIndex].move(dx,dy),this.points[handleIndex].x<-this.centre.x&&(this.points[handleIndex].x=-this.centre.x),this.points[handleIndex].x>maxX-this.centre.x&&(this.points[handleIndex].x=maxX-this.centre.x),this.points[handleIndex].y<-this.centre.y&&(this.points[handleIndex].y=-this.centre.y),this.points[handleIndex].y>maxY-this.centre.y&&(this.points[handleIndex].y=maxY-this.centre.y)},Polygon.prototype.addNewPointAfter=function(pointIndex){this.points.splice(pointIndex,0,new Point(this.points[pointIndex].x,this.points[pointIndex].y))},Polygon.prototype.normalizeShape=function(){var i,x=0,y=0;if(0!==this.points.length){for(i=0;i<this.points.length;i++)x+=this.points[i].x,y+=this.points[i].y;if(x=Math.round(x/this.points.length),y=Math.round(y/this.points.length),0!==x||0!==y){for(i=0;i<this.points.length;i++)this.points[i].move(-x,-y);this.centre.move(x,y)}}},Polygon.prototype.makeSimilarCircle=function(){return this.makeSimilarRectangle().makeSimilarCircle()},Polygon.prototype.makeSimilarRectangle=function(){for(var p,minX=0,maxX=0,minY=0,maxY=0,i=0;i<this.points.length;i++)p=this.points[i],minX=Math.min(minX,p.x),maxX=Math.max(maxX,p.x),minY=Math.min(minY,p.y),maxY=Math.max(maxY,p.y);return new Rectangle(this.label,this.centre.x+minX,this.centre.y+minY,Math.max(maxX-minX,10),Math.max(maxY-minY,10))},Polygon.prototype.getHandlePositions=function(){for(var editHandles=[],i=0;i<this.points.length;i++)editHandles.push(this.points[i].offset(this.centre.x,this.centre.y));return this.centre.x=this.centre.x*parseFloat(this.ratio),this.centre.y=this.centre.y*parseFloat(this.ratio),{moveHandle:this.centre,editHandles:editHandles}},NullShape.prototype=new Shape,NullShape.prototype.getType=function(){return"null"},NullShape.prototype.getCoordinates=function(){return""},NullShape.prototype.makeSvg=function(svg){return null},NullShape.prototype.updateSvg=function(svgEl){},NullShape.prototype.parse=function(coordinates){return!1},NullShape.prototype.makeSimilarCircle=function(){return new Circle(this.label)},NullShape.prototype.makeSimilarRectangle=function(){return new Rectangle(this.label)},NullShape.prototype.makeSimilarPolygon=function(){return new Polygon(this.label)},{Point:Point,Shape:Shape,Circle:Circle,Rectangle:Rectangle,Polygon:Polygon,NullShape:NullShape,createSvgElement:createSvgElement,make:function(shapeType,label){switch(shapeType){case"circle":return new Circle(label);case"rectangle":return new Rectangle(label);case"polygon":return new Polygon(label);default:return new NullShape(label)}},getSimilar:function(shapeType,shape){if(shapeType===shape.getType())return shape;switch(shapeType){case"circle":return shape.makeSimilarCircle();case"rectangle":return shape.makeSimilarRectangle();case"polygon":return shape.makeSimilarPolygon();default:return new NullShape(shape.label)}}}}));

//# sourceMappingURL=shapes.min.js.map