/**
 * This class provides the enhancements to the drag-drop marker editing form.
 *
 * @package    qtype_ddmarker
 * @subpackage form
 * @copyright  2018 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_ddmarker/form",["jquery","core/dragdrop","qtype_ddmarker/shapes"],(function($,dragDrop,Shapes){function DropZoneManager(dropzoneNo){this.dropzoneNo=dropzoneNo,this.svgEl=null,this.shape=Shapes.make(this.getShapeType(),this.getLabel()),this.updateCoordinatesFromForm()}DropZoneManager.prototype.updateCoordinatesFromForm=function(svg){var coordinates=this.getCoordinates(),currentNumPoints="polygon"===this.shape.getType()&&this.shape.points.length;if(this.shape.getCoordinates()!==coordinates&&this.shape.parse(coordinates,1)){if("polygon"===this.shape.getType()&&currentNumPoints!==this.shape.points.length){var currentyActive=this.isActive();this.removeFromSvg(),svg&&(this.addToSvg(svg),currentyActive&&this.setActive())}else this.updateSvgEl();this.setCoordinatesInForm()}},DropZoneManager.prototype.updateLabel=function(){var label=this.getLabel();this.shape.label!==label&&(this.shape.label=label,this.updateSvgEl())},DropZoneManager.prototype.changeShape=function(svg){var newShapeType=this.getShapeType(),currentyActive=this.isActive();newShapeType!==this.shape.getType()&&(this.removeFromSvg(),this.shape=Shapes.getSimilar(newShapeType,this.shape),svg&&(this.addToSvg(svg),currentyActive&&this.setActive()),this.setCoordinatesInForm())},DropZoneManager.prototype.addToSvg=function(svg){if(null!==this.svgEl)throw new Error("this.svgEl already set");if(this.svgEl=this.shape.makeSvg(svg),this.svgEl){this.svgEl.setAttribute("class","dropzone"),this.svgEl.setAttribute("data-dropzone-no",this.dropzoneNo);var handles=this.shape.getHandlePositions();if(null!==handles){var moveHandle=Shapes.createSvgElement(this.svgEl,"circle");moveHandle.setAttribute("cx",handles.moveHandle.x),moveHandle.setAttribute("cy",handles.moveHandle.y),moveHandle.setAttribute("r",7),moveHandle.setAttribute("class","handle move");for(var i=0;i<handles.editHandles.length;++i)this.makeEditHandle(i,handles.editHandles[i])}}},DropZoneManager.prototype.makeEditHandle=function(index,point){var editHandle=Shapes.createSvgElement(this.svgEl,"rect");editHandle.setAttribute("x",point.x-6),editHandle.setAttribute("y",point.y-6),editHandle.setAttribute("width",11),editHandle.setAttribute("height",11),editHandle.setAttribute("class","handle edit"),editHandle.setAttribute("data-edit-handle-no",index)},DropZoneManager.prototype.removeFromSvg=function(){null!==this.svgEl&&(this.svgEl.parentNode.removeChild(this.svgEl),this.svgEl=null)},DropZoneManager.prototype.updateSvgEl=function(){if(null!==this.svgEl){this.shape.updateSvg(this.svgEl);var handles=this.shape.getHandlePositions();if(null!==handles){this.svgEl.childNodes[2].setAttribute("cx",handles.moveHandle.x),this.svgEl.childNodes[2].setAttribute("cy",handles.moveHandle.y);for(var i=0;i<handles.editHandles.length;++i)this.svgEl.childNodes[3+i].setAttribute("x",handles.editHandles[i].x-6),this.svgEl.childNodes[3+i].setAttribute("y",handles.editHandles[i].y-6)}}},DropZoneManager.prototype.isActive=function(){return null!==this.svgEl&&this.svgEl.getAttribute("class").match(/\bactive\b/)},DropZoneManager.prototype.setActive=function(){var parent=this.svgEl.parentNode;parent.removeChild(this.svgEl),parent.appendChild(this.svgEl),this.svgEl.setAttribute("class",this.svgEl.getAttribute("class")+" active")},DropZoneManager.prototype.setCoordinatesInForm=function(){dragDropForm.form.setFormValue("drops",[this.dropzoneNo,"coords"],this.shape.getCoordinates())},DropZoneManager.prototype.getCoordinates=function(){return dragDropForm.form.getFormValue("drops",[this.dropzoneNo,"coords"]).replace(/\s*/g,"")},DropZoneManager.prototype.getChoiceNo=function(){return dragDropForm.form.getFormValue("drops",[this.dropzoneNo,"choice"])},DropZoneManager.prototype.getLabel=function(){return dragDropForm.form.getMarkerText(this.getChoiceNo())},DropZoneManager.prototype.getShapeType=function(){return dragDropForm.form.getFormValue("drops",[this.dropzoneNo,"shape"])},DropZoneManager.prototype.handleMove=function(e){var info=dragDrop.prepare(e);if(info.start){var movingDropZone=this,lastX=info.x,lastY=info.y,dragProxy=this.makeDragProxy(info.x,info.y),bgImg=$("fieldset#id_previewareaheader .dropbackground"),maxX=bgImg.width(),maxY=bgImg.height();dragDrop.start(e,$(dragProxy),(function(pageX,pageY){movingDropZone.shape.move(pageX-lastX,pageY-lastY,maxX,maxY),lastX=pageX,lastY=pageY,movingDropZone.updateSvgEl(),movingDropZone.setCoordinatesInForm()}),(function(){document.body.removeChild(dragProxy)}))}},DropZoneManager.prototype.handleEdit=function(e,handleIndex,svg){var info=dragDrop.prepare(e);if(info.start){"polygon"===this.shape.getType()&&(e.ctrlKey||e.metaKey)&&(this.shape.addNewPointAfter(handleIndex),this.removeFromSvg(),this.addToSvg(svg),this.setActive());var changingDropZone=this,lastX=info.x,lastY=info.y,dragProxy=this.makeDragProxy(info.x,info.y),bgImg=$("fieldset#id_previewareaheader .dropbackground"),maxX=bgImg.width(),maxY=bgImg.height();dragDrop.start(e,$(dragProxy),(function(pageX,pageY){changingDropZone.shape.edit(handleIndex,pageX-lastX,pageY-lastY,maxX,maxY),lastX=pageX,lastY=pageY,changingDropZone.updateSvgEl(),changingDropZone.setCoordinatesInForm()}),(function(){document.body.removeChild(dragProxy),changingDropZone.shape.normalizeShape(),changingDropZone.updateSvgEl(),changingDropZone.setCoordinatesInForm()}))}},DropZoneManager.prototype.makeDragProxy=function(x,y){var dragProxy=document.createElement("div");return dragProxy.style.position="absolute",dragProxy.style.top=y+"px",dragProxy.style.left=x+"px",dragProxy.style.width="1px",dragProxy.style.height="1px",document.body.appendChild(dragProxy),dragProxy};var dragDropForm={fp:null,noDropZones:null,dropZones:[],init:function(){dragDropForm.fp=dragDropForm.filePickers(),dragDropForm.noDropZones=dragDropForm.form.getFormValue("nodropzone",[]),dragDropForm.setupPreviewArea(),dragDropForm.setOptionsForDragItemSelectors(),dragDropForm.createShapes(),dragDropForm.setupEventHandlers(),dragDropForm.waitForFilePickerToInitialise()},setupPreviewArea:function(){$("fieldset#id_previewareaheader div.fcontainer").append('<div class="ddarea que ddmarker">   <div id="ddm-droparea" class="droparea">       <img class="dropbackground" />       <div id="ddm-dropzone" class="dropzones">       </div>   </div></div>')},setOptionsForDragItemSelectors:function(){var selector,i,label,dragItemsOptions={0:""},noItems=dragDropForm.form.getFormValue("noitems",[]),selectedValues=[];for(i=1;i<=noItems;i++)""!==(label=dragDropForm.form.getMarkerText(i))&&(dragItemsOptions[i]=$("<div/>").text(label).html());for(i=0;i<dragDropForm.noDropZones;i++)selector=$("#id_drops_"+i+"_choice"),selectedValues[i]=Number(selector.val());for(i=0;i<dragDropForm.noDropZones;i++){for(var value in(selector=$("#id_drops_"+i+"_choice")).find("option").remove(),dragItemsOptions){var option='<option value="'+(value=Number(value))+'">'+dragItemsOptions[value]+"</option>";selector.append(option);var optionnode=selector.find('option[value="'+value+'"]');if(0!==value)if(value!==selectedValues[i]){var noofdrags=dragDropForm.form.getFormValue("drags",[value-1,"noofdrags"]);if(0!==Number(noofdrags))for(var k in selectedValues)if(Number(selectedValues[k])===value){if(1===Number(noofdrags)){optionnode.attr("disabled",!0);break}noofdrags--}}else optionnode.attr("selected",!0)}dragDropForm.dropZones.length>0&&dragDropForm.dropZones[i].updateLabel()}},createShapes:function(){for(var dropzoneNo=0;dropzoneNo<dragDropForm.noDropZones;dropzoneNo++)dragDropForm.dropZones[dropzoneNo]=new DropZoneManager(dropzoneNo)},setupEventHandlers:function(){$("fieldset#id_draggableitemheader").on("change input","input, select",(function(){dragDropForm.setOptionsForDragItemSelectors()})),$("fieldset#id_dropzoneheader").on("change input","input, select",(function(e){var ids=e.currentTarget.name.match(/^drops\[(\d+)]\[([a-z]*)]$/);if(ids){var dropzoneNo=ids[1],inputType=ids[2],dropZone=dragDropForm.dropZones[dropzoneNo];switch(inputType){case"shape":dropZone.changeShape(dragDropForm.form.getSvg());break;case"coords":dropZone.updateCoordinatesFromForm(dragDropForm.form.getSvg());break;case"choice":dropZone.updateLabel()}}}));var previewArea=$("fieldset#id_previewareaheader");previewArea.on("click","g.dropzone",(function(e){var dropzoneNo=$(e.currentTarget).data("dropzone-no"),currentlyActive=dragDropForm.dropZones[dropzoneNo].isActive();$(dragDropForm.form.getSvg()).find(".dropzone.active").removeClass("active"),currentlyActive||dragDropForm.dropZones[dropzoneNo].setActive()})),previewArea.on("mousedown touchstart",".dropzone .handle.move",(function(e){var dropzoneNo=$(e.currentTarget).closest("g").data("dropzoneNo");dragDropForm.dropZones[dropzoneNo].handleMove(e)})),previewArea.on("mousedown touchstart",".dropzone .handle.edit",(function(e){var dropzoneNo=$(e.currentTarget).closest("g").data("dropzoneNo"),handleIndex=e.currentTarget.getAttribute("data-edit-handle-no");dragDropForm.dropZones[dropzoneNo].handleEdit(e,handleIndex,dragDropForm.form.getSvg())}))},waitForFilePickerToInitialise:function(){null!==dragDropForm.fp.file("bgimage").href?($("form.mform").on("change","#id_bgimage",dragDropForm.loadPreviewImage),dragDropForm.loadPreviewImage()):setTimeout(dragDropForm.waitForFilePickerToInitialise,1e3)},loadPreviewImage:function(){$("fieldset#id_previewareaheader .dropbackground").one("load",dragDropForm.afterPreviewImageLoaded).attr("src",dragDropForm.fp.file("bgimage").href)},afterPreviewImageLoaded:function(){var bgImg=$("fieldset#id_previewareaheader .dropbackground");$("#ddm-dropzone").css("position","relative").css("top",-1*(bgImg.height()+1)),$("#ddm-droparea").css("height",bgImg.height()+20),dragDropForm.updateSvgDisplay()},updateSvgDisplay:function(){var dropzoneNo,bgImg=$("fieldset#id_previewareaheader .dropbackground");if(dragDropForm.form.getSvg())for(dropzoneNo=0;dropzoneNo<dragDropForm.noDropZones;dropzoneNo++)dragDropForm.dropZones[dropzoneNo].updateSvgEl();else for($("#ddm-dropzone").html('<svg xmlns="http://www.w3.org/2000/svg" class="dropzones" width="'+bgImg.outerWidth()+'" height="'+bgImg.outerHeight()+'"></svg>'),dropzoneNo=0;dropzoneNo<dragDropForm.noDropZones;dropzoneNo++)dragDropForm.dropZones[dropzoneNo].addToSvg(dragDropForm.form.getSvg())},form:{getMarkerText:function(markerNo){return 0!==Number(markerNo)?dragDropForm.form.getFormValue("drags",[markerNo-1,"label"]).replace(new RegExp("^\\s*(.*)\\s*$"),"$1"):""},getSvg:function(){var svg=$("fieldset#id_previewareaheader svg");return 0===svg.length?null:svg[0]},toNameWithIndex:function(name,indexes){for(var indexString=name,i=0;i<indexes.length;i++)indexString=indexString+"["+indexes[i]+"]";return indexString},getEl:function(name,indexes){return $("form.mform")[0].elements[this.toNameWithIndex(name,indexes)]},getFormValue:function(name,indexes){var el=this.getEl(name,indexes);return"checkbox"===el.type?el.checked:el.value},setFormValue:function(name,indexes,value){var el=this.getEl(name,indexes);"checkbox"===el.type?el.checked=value:el.value=value}},filePickers:function(){var draftItemIdsToName,nameToParentNode;return void 0===draftItemIdsToName&&(draftItemIdsToName={},nameToParentNode={},$("form.mform input.filepickerhidden").each((function(key,filepicker){draftItemIdsToName[filepicker.value]=filepicker.name,nameToParentNode[filepicker.name]=filepicker.parentNode}))),{file:function(name){var fileAnchor=$(nameToParentNode[name]).find("div.filepicker-filelist a");return fileAnchor.length?{href:fileAnchor.get(0).href,name:fileAnchor.get(0).innerHTML}:{href:null,name:null}},name:function(draftitemid){return draftItemIdsToName[draftitemid]}}}};return{init:dragDropForm.init}}));

//# sourceMappingURL=form.min.js.map